/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.security;

import com.solarterms.hakuro.framework.utils.security.Base64Utils;
import com.solarterms.hakuro.framework.utils.security.EncodingUtils;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesUtils {
    public static final String ALGORITHM = "DES/ECB/PKCS5Padding";
    private static final String KEY_ALGORITHM = "DES";
    private static final String CHARSET = "utf-8";

    public static String encrypt(String key, String plainText) {
        byte[] keyBytes = Base64Utils.decode(key);
        byte[] textBytes = EncodingUtils.encode(plainText);
        byte[] encryptedBytes = DesUtils.encrypt(keyBytes, textBytes);
        return Base64Utils.encode(encryptedBytes);
    }

    public static String decrypt(String key, String encryptedText) {
        byte[] keyBytes = Base64Utils.decode(key);
        byte[] encryptedBytes = Base64Utils.decode(encryptedText);
        byte[] textBytes = DesUtils.decrypt(keyBytes, encryptedBytes);
        return EncodingUtils.decode(textBytes);
    }

    public static byte[] encrypt(byte[] key, byte[] src) {
        return DesUtils.security(key, src, 1);
    }

    public static byte[] decrypt(byte[] key, byte[] src) {
        return DesUtils.security(key, src, 2);
    }

    private static byte[] security(byte[] key, byte[] src, int cipherType) {
        try {
            SecretKey securityKey = SecretKeyFactory.getInstance(KEY_ALGORITHM).generateSecret(new DESKeySpec(key));
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(cipherType, securityKey);
            return c1.doFinal(src);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getKey() {
        return Base64Utils.encode(DesUtils.getKeyBytes());
    }

    public static byte[] getKeyBytes() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        kg.init(56);
        SecretKey secretKey = kg.generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        if (keyBytes.length != 8) {
            throw new IllegalArgumentException("key length is invaid!");
        }
        return keyBytes;
    }

    public static void main(String[] args) throws Exception {
        String key = DesUtils.getKey();
        System.out.println(key);
        String plainText = "Hello World!";
        String encryptedText = DesUtils.encrypt(key, plainText);
        String text = DesUtils.decrypt(key, encryptedText);
        System.out.println(text);
    }
}

