/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.math;

public class ByteUtils {
    public static String byteToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String strHex = Integer.toHexString(bytes[i]);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0" + strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtils.charToByte(hexChars[pos]) << 4 | ByteUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] intToBytes(int i) {
        byte[] bt = new byte[]{(byte)(0xFF & i), (byte)((0xFF00 & i) >> 8), (byte)((0xFF0000 & i) >> 16), (byte)((0xFF000000 & i) >> 24)};
        return bt;
    }

    public static int bytesToInt(byte[] bytes) {
        int num = bytes[0] & 0xFF;
        num |= bytes[1] << 8 & 0xFF00;
        num |= bytes[2] << 16 & 0xFF0000;
        return num |= bytes[3] << 24 & 0xFF000000;
    }

    public static byte[] longToBytes(long number) {
        long temp = number;
        byte[] b = new byte[8];
        for (int i = 0; i < b.length; ++i) {
            b[i] = new Long(temp & 0xFFL).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static long bytesToLong(byte[] b) {
        long s = 0L;
        long s0 = b[0] & 0xFF;
        long s1 = b[1] & 0xFF;
        long s2 = b[2] & 0xFF;
        long s3 = b[3] & 0xFF;
        long s4 = b[4] & 0xFF;
        long s5 = b[5] & 0xFF;
        long s6 = b[6] & 0xFF;
        long s7 = b[7] & 0xFF;
        s = s0 | (s1 <<= 8) | (s2 <<= 16) | (s3 <<= 24) | (s4 <<= 32) | (s5 <<= 40) | (s6 <<= 48) | (s7 <<= 56);
        return s;
    }
}

