/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.log;

import com.solarterms.hakuro.framework.core.annotation.SensitiveInfo;
import com.solarterms.hakuro.framework.core.bean.BaseBean;
import com.solarterms.hakuro.framework.utils.converter.BeanUtils;
import com.solarterms.hakuro.framework.utils.converter.JsonUtils;
import com.solarterms.hakuro.framework.utils.security.SensitiveUtils;
import org.slf4j.Logger;

public class LogUtils {
    public static void debug(Logger logger, Object ... msg) {
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtils.concatMsg(msg));
        }
    }

    public static void debug(Logger logger, Throwable t, Object ... msg) {
        if (logger.isDebugEnabled()) {
            String extMsg = "";
            if (msg != null) {
                extMsg = " (" + LogUtils.concatMsg(msg) + ")";
            }
            logger.debug(t.getMessage() + extMsg, t);
        }
    }

    public static void info(Logger logger, Object ... msg) {
        if (logger.isInfoEnabled()) {
            logger.info(LogUtils.concatMsg(msg));
        }
    }

    public static void info(Logger logger, Throwable t, Object ... msg) {
        if (logger.isInfoEnabled()) {
            String extMsg = "";
            if (msg != null) {
                extMsg = " (" + LogUtils.concatMsg(msg) + ")";
            }
            logger.info(t.getMessage() + extMsg, t);
        }
    }

    public static void warn(Logger logger, Object ... msg) {
        if (logger.isWarnEnabled()) {
            logger.warn(LogUtils.concatMsg(msg));
        }
    }

    public static void warn(Logger logger, Throwable t, Object ... msg) {
        if (logger.isWarnEnabled()) {
            String extMsg = "";
            if (msg != null) {
                extMsg = " (" + LogUtils.concatMsg(msg) + ")";
            }
            logger.warn(t.getMessage() + extMsg, t);
        }
    }

    public static void error(Logger logger, Object ... msg) {
        if (logger.isErrorEnabled()) {
            logger.error(LogUtils.concatMsg(msg));
        }
    }

    public static void error(Logger logger, Throwable t, Object ... msg) {
        if (logger.isErrorEnabled()) {
            String extMsg = "";
            if (msg != null) {
                extMsg = " (" + LogUtils.concatMsg(msg) + ")";
            }
            logger.error(t.getMessage() + extMsg, t);
        }
    }

    private static String concatMsg(Object ... msg) {
        StringBuilder sb = new StringBuilder();
        for (Object each : msg) {
            Object obj;
            if (null == each) {
                sb.append("");
                continue;
            }
            if (each instanceof String) {
                sb.append(each);
                continue;
            }
            if (null == each.getClass().getAnnotation(SensitiveInfo.class)) {
                obj = each;
            } else {
                obj = BeanUtils.deepClone(each);
                SensitiveUtils.sensitiveHandle(obj);
            }
            if (obj instanceof BaseBean) {
                sb.append(JsonUtils.toNonNullJsonString(obj));
                continue;
            }
            sb.append(obj);
        }
        return sb.toString();
    }
}

