/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.io;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    public static String getRootPath() {
        String rootPath;
        String path = System.getenv("PATH");
        if (!path.startsWith(rootPath = "/")) {
            rootPath = String.format("%s:\\", path.substring(0, 1));
        }
        return rootPath;
    }

    public static byte[] readBytes(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (IOException e) {
            LogUtils.error(Log.CTRL_DIGEST_LOGGER, e, "File to Bytes error");
        }
        return buffer;
    }

    public static byte[] readBytes(String filePath) {
        File file = new File(filePath);
        return FileUtils.readBytes(file);
    }

    public static byte[] readBytes(String parentPath, String fileName) {
        File file = new File(parentPath, fileName);
        return FileUtils.readBytes(file);
    }

    public static void writeFile(byte[] byteArr, File targetFile) {
        try {
            FileOutputStream output = new FileOutputStream(targetFile);
            BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
            bufferedOutput.write(byteArr);
            bufferedOutput.flush();
            bufferedOutput.close();
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            LogUtils.error(Log.CTRL_DIGEST_LOGGER, e, "Bytes to File error");
        }
    }

    public static void writeFile(byte[] byteArr, String filePath) {
        File targetFile = new File(filePath);
        FileUtils.writeFile(byteArr, targetFile);
    }

    public static void writeFile(byte[] byteArr, String parentPath, String fileName) {
        File targetFile = new File(parentPath, fileName);
        FileUtils.writeFile(byteArr, targetFile);
    }
}

