/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.http;

import com.solarterms.hakuro.framework.utils.converter.JsonUtils;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    public static final String DEFAULT_ENCODING = "utf8";
    public static final String JSON_CONTENT_TYPE = "application/json;chatset=utf8";
    public static final String XML_CONTENT_TYPE = "application/xml";

    public static <T> T postForm(String url, List<NameValuePair> parameter, ResponseHandler<T> handler) {
        return HttpUtils.postForm(url, parameter, handler, null);
    }

    public static <T> T postForm(String url, List<NameValuePair> parameter, ResponseHandler<T> handler, Header ... header) {
        Object res = null;
        HttpClient client = HttpUtils.createClient(url);
        HttpPost post = new HttpPost(url);
        try {
            if (header != null) {
                for (Header each : header) {
                    post.setHeader(each);
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameter, StandardCharsets.UTF_8));
            res = client.execute((HttpUriRequest)post, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            post.releaseConnection();
        }
        return (T)res;
    }

    public static <T> T postJson(String url, ResponseHandler<T> handler) {
        return HttpUtils.postJson(url, null, handler, (Header[])null);
    }

    public static <T> T postJson(String url, String jsonString, ResponseHandler<T> handler) {
        return HttpUtils.postJson(url, jsonString, handler, (Header[])null);
    }

    public static <T> T postJson(String url, ResponseHandler<T> handler, Header ... header) {
        return HttpUtils.postJson(url, null, handler, header);
    }

    public static <T> T postJsonBean(String url, Object param, final Class<T> resultClazz, Header ... header) {
        String jsonString = JsonUtils.toJsonString(param);
        ResponseHandler handler = new ResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity httpEntity = response.getEntity();
                    Object obj = JsonUtils.toJavaObject(EntityUtils.toString((HttpEntity)httpEntity), resultClazz);
                    return obj;
                }
                throw new IllegalStateException("post json bean fail:" + response.getStatusLine().getStatusCode());
            }
        };
        return HttpUtils.postJson(url, jsonString, handler, header);
    }

    public static <T> T postJson(String url, String jsonString, ResponseHandler<T> handler, Header ... header) {
        Object res = null;
        HttpClient client = HttpUtils.createClient(url);
        HttpPost post = new HttpPost(url);
        try {
            if (header != null) {
                for (Header each : header) {
                    post.setHeader(each);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
                StringEntity s = new StringEntity(jsonString, DEFAULT_ENCODING);
                s.setContentType(JSON_CONTENT_TYPE);
                post.setEntity((HttpEntity)s);
            }
            res = client.execute((HttpUriRequest)post, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            post.releaseConnection();
        }
        return (T)res;
    }

    public static <T> T get(String url, ResponseHandler<T> handler, Header ... header) {
        Object res = null;
        HttpClient client = HttpUtils.createClient(url);
        HttpGet get = new HttpGet(url);
        try {
            if (header != null) {
                for (Header each : header) {
                    get.setHeader(each);
                }
            }
            res = client.execute((HttpUriRequest)get, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            get.releaseConnection();
        }
        return (T)res;
    }

    public static <T> T get(String url, Map<String, String> parameter, ResponseHandler<T> handler, Header ... header) {
        StringBuffer sb = new StringBuffer(url).append("?");
        parameter.forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append("&"));
        String getUrl = sb.substring(0, sb.length() - 1);
        return HttpUtils.get(getUrl, handler, header);
    }

    public static <T> T putJson(String url, String jsonString, ResponseHandler<T> handler, Header ... header) {
        Object res = null;
        HttpClient client = HttpUtils.createClient(url);
        HttpPut put = new HttpPut(url);
        try {
            if (header != null) {
                for (Header each : header) {
                    put.setHeader(each);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
                StringEntity s = new StringEntity(jsonString, DEFAULT_ENCODING);
                s.setContentType(JSON_CONTENT_TYPE);
                put.setEntity((HttpEntity)s);
            }
            res = client.execute((HttpUriRequest)put, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            put.releaseConnection();
        }
        return (T)res;
    }

    public static <T> T postXml(String url, String xmlString, String encoding, ResponseHandler<T> handler) {
        return HttpUtils.postXml(url, xmlString, encoding, handler, null);
    }

    public static <T> T postXml(String url, String xmlString, ResponseHandler<T> handler) {
        return HttpUtils.postXml(url, xmlString, DEFAULT_ENCODING, handler, null);
    }

    public static <T> T postXml(String url, String xmlString, String encoding, ResponseHandler<T> handler, Header ... header) {
        Object res = null;
        HttpClient client = HttpUtils.createClient(url);
        HttpPost post = new HttpPost(url);
        try {
            if (header != null) {
                for (Header each : header) {
                    post.setHeader(each);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)xmlString)) {
                StringEntity s = new StringEntity(xmlString, encoding);
                s.setContentType(XML_CONTENT_TYPE);
                post.setEntity((HttpEntity)s);
            }
            res = client.execute((HttpUriRequest)post, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            post.releaseConnection();
        }
        return (T)res;
    }

    private static HttpClient createClient(String url) {
        HttpClient client = null;
        if (url.startsWith("https")) {
            client = HttpUtils.createSSLClientDefault();
        } else if (url.startsWith("http")) {
            client = HttpClients.createDefault();
        }
        return client;
    }

    private static HttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void main(String[] args) {
        String a = "http://api.fist.xinxiannv.com/metadata/getRegion.do";
        HttpUtils.postJson(a, "{\"channel\":2, \"protocolVer\":\"1.0\", \"appVer\":\"1.0\"}", new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity httpEntity = response.getEntity();
                    System.out.println(EntityUtils.toString((HttpEntity)httpEntity));
                }
                System.out.println(response.getStatusLine().getStatusCode());
                return null;
            }
        });
    }
}

