/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.function;

import java.nio.charset.Charset;
import java.util.UUID;

public abstract class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static boolean equals(Object obj1, Object obj2) {
        String str1 = null;
        String str2 = null;
        if (obj1 != null) {
            str1 = obj1.toString();
        }
        if (obj2 != null) {
            str2 = obj2.toString();
        }
        return StringUtils.equals((CharSequence)str1, (CharSequence)str2);
    }

    public static String upperFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new NullPointerException();
        }
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static boolean containsMb4Char(String input) {
        if (input == null) {
            return false;
        }
        byte[] bytes = input.getBytes(UTF8);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if ((b & 0xF0) == 240) {
                return true;
            }
            if ((b & 0xE0) == 224) {
                i += 2;
                continue;
            }
            if ((b & 0xC0) != 192) continue;
            ++i;
        }
        return false;
    }

    public static String replaceMb4Char(String input, String replacement) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        byte[] bytes = input.getBytes(UTF8);
        char[] chars = input.toCharArray();
        int charIdx = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if ((b & 0xF0) == 240) {
                sb.append(replacement);
                charIdx += 2;
                i += 3;
                continue;
            }
            if ((b & 0xE0) == 224) {
                i += 2;
            } else if ((b & 0xC0) == 192) {
                ++i;
            }
            sb.append(chars[charIdx]);
            ++charIdx;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String input = "\u5357\u4eac\u5e02\u6ea7\u6c34\u533a\u8363\u76db\u94c1\u6728\u5236\u54c1\ud840\udc86";
        System.out.println(input);
        boolean hasT = StringUtils.containsMb4Char(input);
        System.out.println(hasT);
        String re = StringUtils.replaceMb4Char(input, "\u5382");
        System.out.println(re);
    }
}

