/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.datetime;

import com.solarterms.hakuro.framework.utils.function.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final long MAX_TIME = 9999999999L;
    public static final String MS = "yyyyMMddHHmmssSSS";
    public static final String SECOND = "yyyyMMddHHmmss";
    public static final String MINUTE = "yyyyMMddHHmm";
    public static final String HOUR = "yyyyMMddHH";
    public static final String DAY = "yyyyMMdd";
    public static final String MONTH = "yyyyMM";
    public static final String YEAR = "yyyy";
    public static final String YYYYMMDD = "YYYYMMDD";
    public static final String MMDDHHMMSS = "MMDDHHMMSS";
    public static final String FMT_MS = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String FMT_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String FMT_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String FMT_HOUR = "yyyy-MM-dd HH";
    public static final String FMT_DAY = "yyyy-MM-dd";
    public static final String FMT_MONTH = "yyyy-MM";
    public static final String FMT_C_SECOND = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String FMT_C_DAY = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String FMT_D_DAY = "yyyy.MM.dd";
    public static final String FMT_C_MS = "yyyy-MM-dd'T'HH:mm:ssZZZ";

    public static int getOffsetDays(Date start, Date end) {
        long t = end.getTime() - start.getTime();
        return (int)(t /= 86400000L);
    }

    public static long getOffsetSecond(Date start, Date end) {
        long second = end.getTime() - start.getTime();
        return second / 1000L;
    }

    public static Date getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        return DateUtils.getDay(DateUtils.now());
    }

    public static Date tonight() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.now());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date toYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.now());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date toHalfYearAgo() {
        return DateUtils.addMonths((Date)DateUtils.today(), (int)-6);
    }

    public static List<Date> getBetweenDays(Date startDay, Date endDay) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (!endDay.before(startDay)) {
            dateList.add(startDay);
            startDay = DateUtils.addDays((Date)startDay, (int)1);
        }
        return dateList;
    }

    public static Date firstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date oneWeekAgo() {
        return DateUtils.addWeeks((Date)DateUtils.today(), (int)-1);
    }

    public static Date oneMonthAgo() {
        return DateUtils.addMonths((Date)DateUtils.today(), (int)-1);
    }

    public static Date parseToDate(String str) {
        return DateUtils.parseToDate(str, SECOND);
    }

    public static Date parseToDate(String str, String patterns) {
        try {
            return DateUtils.parseDate((String)str, (String[])new String[]{patterns});
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String convertFormat(String day, String pattern, String toPattern) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)day)) {
            return day;
        }
        day = StringUtils.trim((String)day);
        try {
            date = DateUtils.parseDate((String)day, (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return DateUtils.format(date, toPattern);
    }

    public static long getCurSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getCurMonthStr() {
        Date date = new Date();
        return DateUtils.getMonthStr(date);
    }

    public static String getMonthStr(Date date) {
        int month = DateUtils.toCalendar((Date)date).get(2) + 1;
        return StringUtils.leftPad((String)String.valueOf(month), (int)2, (String)"0");
    }

    public static long getBeforeTime(long ms) {
        return System.currentTimeMillis() - ms;
    }

    public static String format(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static String format(Date date) {
        return DateUtils.format(date, SECOND);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Long parseSec(String str, String pattern) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return DateUtils.parseMs(str, pattern) / 1000L;
    }

    public static Long parseMs(String str, String pattern) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ParseException("Unable to parse the date: " + str, -1);
        }
        Date date = DateUtils.parseDate((String)str, (String[])new String[]{pattern});
        return date.getTime();
    }

    public static String formatBySec(Long time, String pattern) {
        if (time == null) {
            return null;
        }
        return DateUtils.format(time * 1000L, pattern);
    }

    public static String format(Long time, String pattern) {
        if (time == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date(time));
    }

    public static String format(String origin, String fromPattern, String toPattern) throws ParseException {
        Long ms = DateUtils.parseMs(origin, fromPattern);
        return DateUtils.format(ms, toPattern);
    }

    public static String convertLinuxTimeToString(Long time, String pattern) {
        Date date = new Date(time * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static boolean compare(Date beginDate, Date endDate) {
        return beginDate != null && endDate != null && beginDate.getTime() <= endDate.getTime();
    }

    public static boolean compareOut(Date beginDate, Date endDate) {
        return beginDate != null && endDate != null && beginDate.getTime() < endDate.getTime();
    }

    public static boolean compareTimeRange(Date beginDate, Date date, Date endDate) {
        return DateUtils.compare(beginDate, date) && DateUtils.compareOut(date, endDate);
    }

    public static boolean compareTimeRange(Date beginDate, Date endDate) {
        return DateUtils.compareTimeRange(beginDate, DateUtils.now(), endDate);
    }

    public static boolean isWorkDay(Date date, Set<Integer> workDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return workDays.contains(dayOfWeek);
    }

    public static boolean isWorkTime(Date date, int startHour, int endHour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hourOfDay = calendar.get(11);
        return hourOfDay >= startHour && hourOfDay < endHour;
    }

    public static boolean isCurrentWorking(Set<Integer> workDays, int startHour, int endHour) {
        Date now = DateUtils.now();
        return DateUtils.isWorkDay(now, workDays) && DateUtils.isWorkTime(now, startHour, endHour);
    }

    public static Date add(Date date, Long dValue, TimeUnit timeUnit) {
        return new Date(date.getTime() + timeUnit.toMillis(dValue));
    }

    public static Date sub(Date date, Long dValue, TimeUnit timeUnit) {
        return new Date(date.getTime() - timeUnit.toMillis(dValue));
    }

    public static Date validPeriodByYear(Date date, int number) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, number);
        return calendar.getTime();
    }

    public static Date validPeriodByMonth(Date date, int number) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, number);
        return calendar.getTime();
    }

    public static Date validPeriodByDay(Date date, int number) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, number);
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 0);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7);
    }

    public static Date truncateDay(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static long getDays(Date startDate, Date endDate) {
        return DateUtils.getDays(startDate, endDate, false);
    }

    public static long getDays(Date startDate, Date endDate, boolean include) {
        if (startDate == null || endDate == null) {
            return 0L;
        }
        long time = DateUtils.truncateDay(endDate).getTime() - DateUtils.truncateDay(startDate).getTime();
        return TimeUnit.MILLISECONDS.toDays(time) + (long)(include ? 1 : 0);
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.format(DateUtils.now(), FMT_C_MS));
        List<Date> betweenDays = DateUtils.getBetweenDays(DateUtils.addMonths((Date)DateUtils.today(), (int)-2), DateUtils.today());
        for (Date betweenDay : betweenDays) {
            System.out.println(betweenDay);
        }
    }
}

