/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.converter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static Boolean isJsonString(String jsonStr) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.readValue(jsonStr, Object.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String toJsonString(Object obj) {
        String jsonStr;
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonStr = mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return jsonStr;
    }

    public static String toNonNullJsonString(Object obj) {
        String jsonStr;
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            jsonStr = mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return jsonStr;
    }

    public static <T> T toJavaObject(String jsonStr, Class<T> clazz) {
        Object obj;
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            obj = mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)obj;
    }

    public static <T> T toJavaObject(String jsonStr, TypeReference clazz) {
        Object obj;
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            obj = mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)obj;
    }
}

