/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.converter;

import java.math.BigDecimal;

public class CoordinateTransformUtils {
    static double x_pi = 52.35987755982988;
    static double pi = Math.PI;
    static double a = 6378245.0;
    static double ee = 0.006693421622965943;

    public static double[] wgs84ToBd09(double lon, double lat) {
        double[] gcj = CoordinateTransformUtils.wgs84ToGcj02(lon, lat);
        return CoordinateTransformUtils.gcj02ToBd09(gcj[0], gcj[1]);
    }

    public static double[] bd09ToWgs84(double lon, double lat) {
        double[] gcj = CoordinateTransformUtils.bd09ToGcj02(lon, lat);
        return CoordinateTransformUtils.gcj02ToWgs84(gcj[0], gcj[1]);
    }

    public static double[] gcj02ToBd09(double lon, double lat) {
        double z = Math.sqrt(lon * lon + lat * lat) + 2.0E-5 * Math.sin(lat * x_pi);
        double theta = Math.atan2(lat, lon) + 3.0E-6 * Math.cos(lon * x_pi);
        double bdLon = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new double[]{bdLon, bdLat};
    }

    public static double[] bd09ToGcj02(double bdLon, double bdLat) {
        double x = bdLon - 0.0065;
        double y = bdLat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double ggLon = z * Math.cos(theta);
        double ggLat = z * Math.sin(theta);
        return new double[]{ggLon, ggLat};
    }

    public static double[] wgs84ToGcj02(double lon, double lat) {
        if (CoordinateTransformUtils.outOfChina(lon, lat)) {
            return new double[]{lon, lat};
        }
        double dlat = CoordinateTransformUtils.transformLat(lon - 105.0, lat - 35.0);
        double dlon = CoordinateTransformUtils.transformLon(lon - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * pi;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (a * (1.0 - ee) / (magic * sqrtmagic) * pi);
        dlon = dlon * 180.0 / (a / sqrtmagic * Math.cos(radlat) * pi);
        double mgLat = lat + dlat;
        double mgLon = lon + dlon;
        double fmtLon = BigDecimal.valueOf(mgLon).setScale(6, 1).doubleValue();
        double fmtLat = BigDecimal.valueOf(mgLat).setScale(6, 1).doubleValue();
        return new double[]{fmtLon, fmtLat};
    }

    public static double[] gcj02ToWgs84(double lon, double lat) {
        if (CoordinateTransformUtils.outOfChina(lon, lat)) {
            return new double[]{lon, lat};
        }
        double dLat = CoordinateTransformUtils.transformLat(lon - 105.0, lat - 35.0);
        double dLon = CoordinateTransformUtils.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{lon * 2.0 - mgLon, lat * 2.0 - mgLat};
    }

    public static double transformLat(double lon, double lat) {
        double ret = -100.0 + 2.0 * lon + 3.0 * lat + 0.2 * lat * lat + 0.1 * lon * lat + 0.2 * Math.sqrt(Math.abs(lon));
        ret += (20.0 * Math.sin(6.0 * lon * pi) + 20.0 * Math.sin(2.0 * lon * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * pi) + 40.0 * Math.sin(lat / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * pi) + 320.0 * Math.sin(lat * pi / 30.0)) * 2.0 / 3.0;
    }

    public static double transformLon(double lon, double lat) {
        double ret = 300.0 + lon + 2.0 * lat + 0.1 * lon * lon + 0.1 * lon * lat + 0.1 * Math.sqrt(Math.abs(lon));
        ret += (20.0 * Math.sin(6.0 * lon * pi) + 20.0 * Math.sin(2.0 * lon * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lon * pi) + 40.0 * Math.sin(lon / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lon / 12.0 * pi) + 300.0 * Math.sin(lon / 30.0 * pi)) * 2.0 / 3.0;
    }

    public static boolean outOfChina(double lon, double lat) {
        return lon < 72.004 || lon > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private static double getRadian(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = CoordinateTransformUtils.getRadian(lat1);
        double radLat2 = CoordinateTransformUtils.getRadian(lat2);
        double a = radLat1 - radLat2;
        double b = CoordinateTransformUtils.getRadian(lng1) - CoordinateTransformUtils.getRadian(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378.137;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s *= 1000.0;
    }

    public static void main(String[] args) {
        double lon = 114.358648;
        double lat = 33.072933;
        System.out.println(CoordinateTransformUtils.outOfChina(lon, lat));
        double[] baidu = CoordinateTransformUtils.wgs84ToBd09(lon, lat);
        System.out.println(baidu[0] + "," + baidu[1]);
        double[] amap = CoordinateTransformUtils.wgs84ToGcj02(lon, lat);
        System.out.println(amap[0] + "," + amap[1]);
        double[] wgs84 = CoordinateTransformUtils.bd09ToWgs84(baidu[0], baidu[1]);
        System.out.println(wgs84[0] + "," + wgs84[1]);
        double jl = CoordinateTransformUtils.getDistance(116.575953, 39.905914, 116.433661, 39.91012);
        System.out.println(jl);
    }
}

