/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.converter;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.core.interfaces.Typeable;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.function.TypeBeanUtils;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.dozer.DozerBeanMapper;

public class BeanUtils {
    private static final DozerBeanMapper MAPPER = new DozerBeanMapper(Collections.singletonList("bean.xml"));

    public static String getPropertyString(Object bean, String propName) {
        Object prop = BeanUtils.getProperty(bean, propName);
        return prop == null ? null : prop.toString();
    }

    public static Object getProperty(Object bean, String propName) {
        try {
            return PropertyUtils.getProperty((Object)bean, (String)propName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        try {
            return PropertyUtils.getPropertyDescriptors(clazz);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @SafeVarargs
    public static <T> T combineProps(Class<T> clazz, T ... objs) {
        try {
            T combined = clazz.newInstance();
            for (Field field : clazz.getDeclaredFields()) {
                for (T obj : objs) {
                    Object value;
                    field.setAccessible(true);
                    if (obj == null || (value = field.get(obj)) == null) continue;
                    field.set(combined, value);
                }
            }
            return combined;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Enum> T getType(Class<T> clazz, String code) {
        Enum type = null;
        List enumList = TypeBeanUtils.getEnumList(clazz);
        for (Enum each : enumList) {
            if (!((Typeable)((Object)each)).getCode().equals(code)) continue;
            type = each;
            break;
        }
        return (T)type;
    }

    public static <T extends Enum> T getCode(Class<T> clazz, String name) {
        Enum type = null;
        List enumList = TypeBeanUtils.getEnumList(clazz);
        for (Enum each : enumList) {
            if (!((Typeable)((Object)each)).getMessage().equals(name)) continue;
            type = each;
            break;
        }
        return (T)type;
    }

    public static void copy(Object orig, Object dest) {
        if (orig == null) {
            return;
        }
        MAPPER.map(orig, dest);
    }

    public static <T> T convert(Object orig, Class<T> clazz) {
        if (orig == null) {
            return null;
        }
        return (T)MAPPER.map(orig, clazz);
    }

    public static Object deepClone(Object orig) {
        if (null == orig) {
            return null;
        }
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bao);
            objectOutputStream.writeObject(orig);
            return new ObjectInputStream(new ByteArrayInputStream(bao.toByteArray())).readObject();
        }
        catch (Exception e) {
            LogUtils.error(Log.ERROR_LOGGER, e, new Object[0]);
            return null;
        }
    }

    public static <T> List<T> convertList(List<?> orig, Class<T> clazz) {
        ArrayList<T> dest = null;
        if (!CollectionUtils.isEmpty(orig)) {
            dest = new ArrayList<T>();
            for (Object each : orig) {
                T destEntry = BeanUtils.convert(each, clazz);
                dest.add(destEntry);
            }
        } else if (orig != null) {
            dest = new ArrayList();
        }
        return dest;
    }

    public static <T> T convert(String str, String split, String[] keyArray, Class<T> clazz) {
        String[] strArray = StringUtils.split((String)str, (String)split);
        HashMap<String, String> strMap = new HashMap<String, String>();
        int i = 0;
        for (String key : keyArray) {
            strMap.put(key, strArray[i]);
            ++i;
        }
        return BeanUtils.convert(strMap, clazz);
    }
}

