/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.core.enums;

import com.solarterms.hakuro.framework.core.interfaces.Typeable;
import com.solarterms.hakuro.framework.utils.function.StringUtils;

public enum BooleanTypeEnum implements Typeable<String>
{
    TRUE("1", "true"),
    FALSE("0", "false");

    private String code;
    private String message;

    public static BooleanTypeEnum parseBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static BooleanTypeEnum parseString(String s) {
        return StringUtils.equals((CharSequence)s, (CharSequence)"1") ? TRUE : FALSE;
    }

    public boolean toBoolean() {
        return StringUtils.equals((CharSequence)this.getCode(), (CharSequence)"1");
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private BooleanTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
}

