/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.core.bean;

import com.solarterms.hakuro.framework.core.bean.BaseBean;
import com.solarterms.hakuro.framework.core.enums.CurrencyEnum;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import java.math.BigDecimal;

public class Money
extends BaseBean
implements Comparable<Money> {
    private static final long serialVersionUID = 1L;
    public static final Money ZERO = new Money();
    private CurrencyEnum cur = CurrencyEnum.CNY;
    private final BigDecimal value;

    public Money() {
        this(BigDecimal.ZERO);
    }

    public Money(long fen) {
        long yuan = fen / 100L;
        long f = fen % 100L;
        BigDecimal number = null;
        number = f == 0L ? new BigDecimal(yuan) : new BigDecimal(yuan + "." + StringUtils.leftPad((String)Long.valueOf(f).toString(), (int)2, (char)'0'));
        if (number.scale() > 2) {
            throw new IllegalArgumentException("money scale is invalid:" + number.scale());
        }
        this.value = number;
    }

    public Money(BigDecimal yuan) {
        if (yuan.scale() > 2) {
            throw new IllegalArgumentException("money scale is invalid:" + yuan.scale());
        }
        this.value = yuan;
    }

    public Money(String yuan) {
        if (StringUtils.isEmpty((CharSequence)yuan)) {
            throw new NullPointerException("money string is not null!");
        }
        BigDecimal number = null;
        try {
            number = new BigDecimal(yuan);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (number.scale() > 2) {
            throw new IllegalArgumentException("money scale is invalid:" + number.scale());
        }
        this.value = number;
    }

    public long longValue() {
        return this.value.longValue();
    }

    public CurrencyEnum getCur() {
        return this.cur;
    }

    public void setCur(CurrencyEnum cur) {
        this.cur = cur;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Money add(Money money) {
        return new Money(this.value.add(money.getValue()));
    }

    public Money subtract(Money money) {
        return new Money(this.value.subtract(money.getValue()));
    }

    public Money multiply(int times) {
        return new Money(this.value.multiply(new BigDecimal(times)));
    }

    public Money multiply(BigDecimal num) {
        return new Money(this.value.multiply(num));
    }

    public Money reverse() {
        return this.multiply(-1);
    }

    @Override
    public String toString() {
        return this.value.toPlainString();
    }

    @Override
    public int compareTo(Money o) {
        return this.value.compareTo(o.getValue());
    }

    public boolean equals(Money o) {
        return this.value.equals(o.getValue());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public static void main(String[] args) {
        Money m = new Money("12.39");
        System.out.println(m);
        System.out.println(m.multiply(2));
        System.out.println(m.add(m));
        System.out.println(m.subtract(m));
        System.out.println(m.subtract(m));
        System.out.println(m);
        m = new Money("-0.36");
        System.out.println(m);
        System.out.println(m.multiply(2));
        System.out.println(m.add(m));
        System.out.println(m.subtract(m));
        System.out.println(m.subtract(m));
        System.out.println(m);
    }
}

