/*
 * Decompiled with CFR 0.152.
 */
package org.artifact.actor;

import cn.hutool.core.util.ObjectUtil;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.artifact.actor.Actor;
import org.artifact.actor.Message;
import org.artifact.actor.MessageEvent;
import org.artifact.actor.MessageListener;

public class DefaultMessage
implements Message {
    protected long delayUntil = -1L;
    protected Actor source;
    protected String subject;
    protected Object data;
    protected List<MessageListener> listeners = new LinkedList<MessageListener>();

    public long getDelayUntil() {
        return this.delayUntil;
    }

    public void setDelayUntil(long delayUntil) {
        long now = new Date().getTime();
        if (delayUntil <= now) {
            throw new IllegalArgumentException("value should be in the future: " + delayUntil + " vs. " + now);
        }
        this.delayUntil = delayUntil;
    }

    @Override
    public Actor getSource() {
        return this.source;
    }

    protected void setSource(Actor source) {
        this.source = source;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    protected void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    protected void setData(Object data) {
        this.data = data;
    }

    public DefaultMessage(String subject, Object data) {
        this(subject);
        this.data = data;
    }

    public DefaultMessage(String subject) {
        this();
        this.subject = subject;
    }

    protected DefaultMessage() {
    }

    public Message assignSender(Actor sender) {
        DefaultMessage res = new DefaultMessage(this.subject, this.data);
        res.source = sender;
        return res;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bodyString() + "]";
    }

    protected String bodyString() {
        return "source=" + this.source + ", subject=" + this.subject + ", data=" + ObjectUtil.toString((Object)this.data) + ", delay=" + this.delayUntil;
    }

    public boolean subjectMatches(String s) {
        return this.subject != null ? this.subject.equals(s) : false;
    }

    public boolean subjectMatches(Pattern p) {
        boolean res = false;
        if (p != null && this.subject != null) {
            Matcher m = p.matcher(this.subject);
            res = m.matches();
        }
        return res;
    }

    public void addMessageListener(MessageListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeMessageListener(MessageListener l) {
        this.listeners.remove(l);
    }

    public void fireMessageListeners(MessageEvent e) {
        for (MessageListener l : this.listeners) {
            l.onMessage(e);
        }
    }
}

