/*
 * Decompiled with CFR 0.152.
 */
package org.artifact.actor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.artifact.actor.AbstractActor;
import org.artifact.actor.Actor;
import org.artifact.actor.ActorManager;
import org.artifact.actor.DefaultMessage;
import org.artifact.actor.Message;
import org.artifact.actor.MessageEvent;

public class DefaultActorManager
implements ActorManager {
    static final Log log = LogFactory.get(DefaultActorManager.class);
    public static final int DEFAULT_ACTOR_THREAD_COUNT = 10;
    protected static DefaultActorManager instance;
    public static final String ACTOR_THREAD_COUNT = "threadCount";
    protected Map<String, AbstractActor> actors = new LinkedHashMap<String, AbstractActor>();
    protected Map<String, AbstractActor> runnables = new LinkedHashMap<String, AbstractActor>();
    protected Map<String, AbstractActor> waiters = new LinkedHashMap<String, AbstractActor>();
    protected Random rand = new Random();
    protected Map<String, List<Message>> sentMessages = new HashMap<String, List<Message>>();
    protected boolean recordSentMessages = true;
    protected volatile long lastSendTime;
    protected volatile long lastDispatchTime;
    protected volatile int sendCount;
    protected volatile int lastSendCount;
    protected volatile int dispatchCount;
    protected volatile int lastDispatchCount;
    protected Map<String, ActorRunnable> trunnables = new HashMap<String, ActorRunnable>();
    protected ThreadGroup threadGroup;
    private boolean initialized;
    protected static int groupCount;
    protected List<Thread> threads = new LinkedList<Thread>();
    boolean running;
    boolean terminated;
    protected int trendValue = 0;
    protected int maxTrendValue = 10;

    public static DefaultActorManager getDefaultInstance() {
        if (instance == null) {
            instance = new DefaultActorManager();
            HashMap<String, String> options = null;
            Properties p = new Properties();
            try {
                p.load(new FileInputStream("ActorManager.properties"));
            }
            catch (IOException e) {
                try {
                    p.load(new FileInputStream("/resource/ActorManager.properties"));
                }
                catch (IOException e1) {
                    log.warn("DefaultActorManager: no configutration: {}", new Object[]{e});
                }
            }
            if (!CollUtil.isEmpty((Map)p)) {
                options = new HashMap<String, String>();
                for (Object key : p.keySet()) {
                    String skey = (String)key;
                    options.put(skey, p.getProperty(skey));
                }
            }
            instance.initialize(options);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachActor(Actor actor) {
        if (((AbstractActor)actor).getManager() != this) {
            throw new IllegalStateException("actor not owned by this manager");
        }
        String name = actor.getName();
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            if (this.actors.containsKey(name)) {
                ((AbstractActor)actor).setManager(null);
                this.actors.remove(name);
                this.runnables.remove(name);
                this.waiters.remove(name);
            } else {
                actor = null;
            }
        }
        if (actor != null) {
            actor.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachAllActors() {
        HashSet<String> xkeys = new HashSet<String>();
        xkeys.addAll(this.actors.keySet());
        Iterator i = xkeys.iterator();
        while (i.hasNext()) {
            this.detachActor(this.actors.get(i.next()));
        }
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            this.actors.clear();
            this.runnables.clear();
            this.waiters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void randomizeActors() {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            AbstractActor[] xactors = this.getActors();
            ArrayList<AbstractActor> zactors = new ArrayList<AbstractActor>(xactors.length);
            for (AbstractActor a : xactors) {
                zactors.add(this.rand.nextInt(zactors.size() + 1), a);
            }
            this.actors.clear();
            for (AbstractActor a : zactors) {
                this.actors.put(a.getName(), a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActorCount(Class type) {
        int res = 0;
        if (type != null) {
            Map<String, AbstractActor> map = this.actors;
            synchronized (map) {
                for (String key : this.actors.keySet()) {
                    Actor a = this.actors.get(key);
                    if (!type.isAssignableFrom(a.getClass())) continue;
                    ++res;
                }
            }
        }
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            res = this.actors.size();
        }
        return res;
    }

    public AbstractActor[] getActors() {
        AbstractActor[] res = new AbstractActor[this.actors.size()];
        this.copyMembers(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyMembers(AbstractActor[] res) {
        int count = 0;
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            for (String key : this.actors.keySet()) {
                res[count++] = this.actors.get(key);
            }
        }
    }

    public boolean getRecordSentMessages() {
        return this.recordSentMessages;
    }

    public void setRecordSentMessages(boolean recordSentMessages) {
        this.recordSentMessages = recordSentMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getAndClearSentMessages(Actor actor) {
        LinkedList<Message> res = null;
        Map<String, List<Message>> map = this.sentMessages;
        synchronized (map) {
            List<Message> l = this.sentMessages.get(actor.getName());
            if (!CollUtil.isEmpty(l)) {
                res = new LinkedList<Message>();
                res.addAll(l);
                l.clear();
            }
        }
        return res != null ? res.toArray(new Message[res.size()]) : null;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getLastDispatchTime() {
        return this.lastDispatchTime;
    }

    public int getSendPerSecondCount() {
        return this.lastSendCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDispatchPerSecondCount() {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            return this.lastDispatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incDispatchCount() {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            ++this.dispatchCount;
            this.lastDispatchTime = new Date().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatchCount() {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            this.dispatchCount = 0;
            this.lastDispatchCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLastDispatchCount() {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            this.lastDispatchCount = this.dispatchCount;
            this.dispatchCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(Message message, Actor from, Actor to) {
        AbstractActor aa;
        int count = 0;
        if (message != null && (aa = (AbstractActor)to) != null && !aa.isShutdown() && !aa.isSuspended() && aa.willReceive(message.getSubject())) {
            Map<String, Object> map;
            DefaultMessage xmessage = (DefaultMessage)((DefaultMessage)message).assignSender(from);
            aa.addMessage(xmessage);
            xmessage.fireMessageListeners(new MessageEvent(aa, xmessage, MessageEvent.MessageStatus.SENT));
            ++this.sendCount;
            this.lastSendTime = new Date().getTime();
            if (this.recordSentMessages) {
                map = this.sentMessages;
                synchronized (map) {
                    String aname = aa.getName();
                    List<Message> l = this.sentMessages.get(aname);
                    if (l == null) {
                        l = new LinkedList<Message>();
                        this.sentMessages.put(aname, l);
                    }
                    if (l.size() < 100) {
                        l.add(xmessage);
                    }
                }
            }
            ++count;
            map = this.actors;
            synchronized (map) {
                this.actors.notifyAll();
            }
        }
        return count;
    }

    @Override
    public int send(Message message, Actor from, Actor[] to) {
        int count = 0;
        for (Actor a : to) {
            count += this.send(message, from, a);
        }
        return count;
    }

    @Override
    public int send(Message message, Actor from, Collection<Actor> to) {
        int count = 0;
        for (Actor a : to) {
            count += this.send(message, from, a);
        }
        return count;
    }

    @Override
    public int send(Message message, Actor from, String category) {
        int count = 0;
        Map<String, Actor> xactors = this.cloneActors();
        LinkedList<Actor> catMembers = new LinkedList<Actor>();
        for (String key : xactors.keySet()) {
            Actor to = xactors.get(key);
            if (!category.equals(to.getCategory()) || to.getMessageCount() >= to.getMaxMessageCount()) continue;
            catMembers.add(to);
        }
        int min = Integer.MAX_VALUE;
        Actor amin = null;
        for (Actor a : catMembers) {
            int mcount = a.getMessageCount();
            if (mcount >= min) continue;
            min = mcount;
            amin = a;
        }
        if (amin != null) {
            count += this.send(message, from, amin);
        }
        return count;
    }

    @Override
    public int broadcast(Message message, Actor from) {
        int count = 0;
        Map<String, Actor> xactors = this.cloneActors();
        for (String key : xactors.keySet()) {
            Actor to = xactors.get(key);
            count += this.send(message, from, to);
        }
        return count;
    }

    @Override
    public Set<String> getCategories() {
        Map<String, Actor> xactors = this.cloneActors();
        TreeSet<String> res = new TreeSet<String>();
        for (String key : xactors.keySet()) {
            Actor a = xactors.get(key);
            res.add(a.getCategory());
        }
        return res;
    }

    public int getCategorySize(String name) {
        Map<String, Actor> xactors = this.cloneActors();
        int res = 0;
        for (String key : xactors.keySet()) {
            Actor a = xactors.get(key);
            if (!a.getCategory().equals(name)) continue;
            ++res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Actor> cloneActors() {
        HashMap<String, Actor> xactors;
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            xactors = new HashMap<String, Actor>(this.actors);
        }
        return xactors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitMessage(AbstractActor actor) {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            this.waiters.put(actor.getName(), actor);
        }
    }

    public ActorRunnable getRunnable(String name) {
        return this.trunnables.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRunnableCount() {
        int res = 0;
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            for (String key : this.trunnables.keySet()) {
                if (!this.trunnables.get((Object)key).hasThread) continue;
                ++res;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread addThread(String name) {
        Thread t = null;
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            if (this.trunnables.containsKey(name)) {
                throw new IllegalStateException("already exists: " + name);
            }
            ActorRunnable r = new ActorRunnable();
            this.trunnables.put(name, r);
            t = new Thread(this.threadGroup, r, name);
            this.threads.add(t);
        }
        t.setDaemon(true);
        t.setPriority(this.getThreadPriority());
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(String name) {
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            if (!this.trunnables.containsKey(name)) {
                throw new IllegalStateException("not running: " + name);
            }
            this.trunnables.remove(name);
            Iterator<Thread> i = this.threads.iterator();
            while (i.hasNext()) {
                Thread xt = i.next();
                if (!xt.getName().equals(name)) continue;
                i.remove();
                xt.interrupt();
                break;
            }
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    protected void createThread(int i) {
        this.addThread("actor" + i);
    }

    @Override
    public void initialize() {
        this.initialize(null);
    }

    @Override
    public void initialize(Map<String, Object> options) {
        if (!this.initialized) {
            ThreadGroup tg;
            this.initialized = true;
            int count = this.getThreadCount(options);
            this.threadGroup = tg = new ThreadGroup("ActorManager" + groupCount++);
            for (int i = 0; i < count; ++i) {
                this.createThread(i);
            }
            this.running = true;
            for (Thread t : this.threads) {
                t.start();
            }
            Thread Counter = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (DefaultActorManager.this.running) {
                        try {
                            DefaultActorManager.this.trendValue = DefaultActorManager.this.sendCount - DefaultActorManager.this.dispatchCount;
                            DefaultActorManager.this.lastSendCount = DefaultActorManager.this.sendCount;
                            DefaultActorManager.this.sendCount = 0;
                            DefaultActorManager.this.updateLastDispatchCount();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    DefaultActorManager.this.lastSendCount = 0;
                    DefaultActorManager.this.sendCount = 0;
                    DefaultActorManager.this.clearDispatchCount();
                }
            });
            Counter.setDaemon(true);
            this.lastDispatchTime = this.lastSendTime = new Date().getTime();
            Counter.start();
        }
    }

    public int getThreadPriority() {
        return Math.max(1, Thread.currentThread().getPriority() - 1);
    }

    protected int getThreadCount(Map<String, Object> options) {
        Object xcount;
        Integer count = null;
        Object object = xcount = options != null ? options.get(ACTOR_THREAD_COUNT) : null;
        if (xcount != null) {
            count = xcount instanceof Integer ? (Integer)xcount : Integer.valueOf(Integer.parseInt(xcount.toString()));
        }
        if (count == null) {
            count = 10;
        }
        return count;
    }

    public Thread[] getThreads() {
        return this.threads.toArray(new Thread[this.threads.size()]);
    }

    @Override
    public void terminateAndWait() {
        log.trace("terminateAndWait waiting on termination of {} threads", new Object[]{this.threads.size()});
        this.terminate();
        this.waitForThreads();
    }

    public void waitForThreads() {
        if (!this.terminated) {
            throw new IllegalStateException("not terminated");
        }
        for (Thread t : this.threads) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminated = true;
        this.running = false;
        for (Thread t : this.threads) {
            t.interrupt();
        }
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            for (String key : this.actors.keySet()) {
                this.actors.get(key).deactivate();
            }
        }
        this.sentMessages.clear();
        this.lastSendCount = 0;
        this.sendCount = 0;
        this.clearDispatchCount();
    }

    @Override
    public Actor createActor(Class<? extends Actor> clazz, String name) {
        return this.createActor(clazz, name, null);
    }

    @Override
    public Actor createAndStartActor(Class<? extends Actor> clazz, String name) {
        return this.createAndStartActor(clazz, name, null);
    }

    @Override
    public Actor createAndStartActor(Class<? extends Actor> clazz, String name, Map<String, Object> options) {
        Actor res = this.createActor(clazz, name, options);
        this.startActor(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Actor createActor(Class<? extends Actor> clazz, String name, Map<String, Object> options) {
        AbstractActor a = null;
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            if (!this.actors.containsKey(name)) {
                try {
                    a = (AbstractActor)clazz.newInstance();
                    a.setName(name);
                    a.setManager(this);
                }
                catch (Exception e) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("mapped exception: " + e, e);
                }
            } else {
                throw new IllegalArgumentException("name already in use: " + name);
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startActor(Actor actor) {
        if (((AbstractActor)actor).getManager() != this) {
            throw new IllegalStateException("actor not owned by this manager");
        }
        String name = actor.getName();
        Map<String, AbstractActor> map = this.actors;
        synchronized (map) {
            if (this.actors.containsKey(name)) {
                throw new IllegalStateException("already started");
            }
            ((AbstractActor)actor).shutdown = false;
            this.actors.put(name, (AbstractActor)actor);
            this.runnables.put(name, (AbstractActor)actor);
        }
        actor.activate();
    }

    public int getTrendValue() {
        return this.trendValue;
    }

    public void setTrendValue(int trendValue) {
        this.trendValue = trendValue;
    }

    public int getMaxTrendValue() {
        return this.maxTrendValue;
    }

    public void setMaxTrendValue(int maxTrendValue) {
        this.maxTrendValue = maxTrendValue;
    }

    public class ActorRunnable
    implements Runnable {
        public boolean hasThread;
        public AbstractActor actor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int delay = 1;
            while (DefaultActorManager.this.running) {
                try {
                    if (!this.procesNextActor()) {
                        Map<String, AbstractActor> map = DefaultActorManager.this.actors;
                        synchronized (map) {
                            DefaultActorManager.this.actors.wait(100L);
                        }
                        delay = Math.max(5, delay + 1);
                        continue;
                    }
                    delay = 1;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    log.error("procesNextActor exception {}", new Object[]{e});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean procesNextActor() {
            String key;
            Iterator<String> iterator;
            boolean run = false;
            boolean wait = false;
            boolean res = false;
            this.actor = null;
            Map<String, AbstractActor> map = DefaultActorManager.this.actors;
            synchronized (map) {
                iterator = DefaultActorManager.this.runnables.keySet().iterator();
                if (iterator.hasNext()) {
                    key = iterator.next();
                    this.actor = DefaultActorManager.this.runnables.remove(key);
                }
            }
            if (this.actor != null) {
                run = true;
                this.actor.setHasThread(true);
                this.hasThread = true;
                try {
                    this.actor.run();
                }
                finally {
                    this.actor.setHasThread(false);
                    this.hasThread = false;
                }
            }
            map = DefaultActorManager.this.actors;
            synchronized (map) {
                iterator = DefaultActorManager.this.waiters.keySet().iterator();
                if (iterator.hasNext()) {
                    key = iterator.next();
                    this.actor = DefaultActorManager.this.waiters.remove(key);
                }
            }
            if (this.actor != null) {
                wait = true;
                this.actor.setHasThread(true);
                this.hasThread = true;
                try {
                    res = this.actor.receive();
                    if (res) {
                        DefaultActorManager.this.incDispatchCount();
                    }
                }
                finally {
                    this.actor.setHasThread(false);
                    this.hasThread = false;
                }
            }
            return run || res;
        }
    }
}

