/*
 * Decompiled with CFR 0.152.
 */
package org.artifact.actor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.artifact.actor.Actor;
import org.artifact.actor.ActorManager;
import org.artifact.actor.DefaultActorManager;
import org.artifact.actor.DefaultMessage;
import org.artifact.actor.Message;
import org.artifact.actor.MessageEvent;

public abstract class AbstractActor
implements Actor {
    static final Log log = LogFactory.get(AbstractActor.class);
    public static final int DEFAULT_MAX_MESSAGES = 100;
    protected DefaultActorManager manager;
    protected String name;
    protected String category = "default";
    protected List<DefaultMessage> messages = new LinkedList<DefaultMessage>();
    protected boolean isActive;
    protected boolean hasThread;
    protected volatile boolean shutdown;
    protected volatile boolean suspended;

    public ActorManager getManager() {
        return this.manager;
    }

    public void setManager(DefaultActorManager manager) {
        if (this.manager != null && manager != null) {
            throw new IllegalStateException("cannot change manager of attached actor");
        }
        this.manager = manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.manager != null) {
            throw new IllegalStateException("cannot change name if manager set");
        }
        this.name = name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public boolean receive() {
        boolean res;
        Message m = this.testMessage();
        boolean bl = res = m != null;
        if (res) {
            boolean f = this.remove(m);
            if (!f) {
                log.warn("receive message not removed: {}", new Object[]{m});
            }
            DefaultMessage dm = (DefaultMessage)m;
            try {
                dm.fireMessageListeners(new MessageEvent(this, dm, MessageEvent.MessageStatus.DELIVERED));
                this.loopBody(m);
                dm.fireMessageListeners(new MessageEvent(this, dm, MessageEvent.MessageStatus.COMPLETED));
            }
            catch (Exception e) {
                dm.fireMessageListeners(new MessageEvent(this, dm, MessageEvent.MessageStatus.FAILED));
                log.error("loop exception {}", new Object[]{e});
            }
        }
        this.manager.awaitMessage(this);
        return res;
    }

    @Override
    public boolean willReceive(String subject) {
        return !StrUtil.isEmpty((CharSequence)subject);
    }

    protected Message testMessage() {
        return this.getMatch(null, false);
    }

    protected abstract void loopBody(Message var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultMessage getMatch(String subject, boolean isRegExpr) {
        DefaultMessage res = null;
        List<DefaultMessage> list = this.messages;
        synchronized (list) {
            res = (DefaultMessage)this.peekNext(subject, isRegExpr);
        }
        return res;
    }

    public DefaultMessage[] getMessages() {
        return this.messages.toArray(new DefaultMessage[this.messages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMessageCount() {
        List<DefaultMessage> list = this.messages;
        synchronized (list) {
            return this.messages.size();
        }
    }

    @Override
    public int getMaxMessageCount() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(DefaultMessage message) {
        if (message != null) {
            List<DefaultMessage> list = this.messages;
            synchronized (list) {
                if (this.messages.size() >= this.getMaxMessageCount()) {
                    throw new IllegalStateException("too many messages, cannot add");
                }
                this.messages.add(message);
            }
        }
    }

    @Override
    public Message peekNext() {
        return this.peekNext(null);
    }

    @Override
    public Message peekNext(String subject) {
        return this.peekNext(subject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message peekNext(String subject, boolean isRegExpr) {
        DefaultMessage res = null;
        if (this.isActive) {
            Pattern p = subject != null ? (isRegExpr ? Pattern.compile(subject) : null) : null;
            long now = new Date().getTime();
            List<DefaultMessage> list = this.messages;
            synchronized (list) {
                for (DefaultMessage m : this.messages) {
                    boolean match;
                    if (m.getDelayUntil() > now || !(match = subject == null || (isRegExpr ? m.subjectMatches(p) : m.subjectMatches(subject)))) continue;
                    res = m;
                    break;
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Message message) {
        List<DefaultMessage> list = this.messages;
        synchronized (list) {
            return this.messages.remove(message);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void activate() {
        this.isActive = true;
    }

    @Override
    public void deactivate() {
        this.isActive = false;
    }

    protected void runBody() {
        DefaultMessage m = new DefaultMessage("init");
        this.getManager().send((Message)m, null, this);
    }

    @Override
    public void run() {
        this.runBody();
        ((DefaultActorManager)this.getManager()).awaitMessage(this);
    }

    public boolean getHasThread() {
        return this.hasThread;
    }

    protected void setHasThread(boolean hasThread) {
        this.hasThread = hasThread;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bodyString() + "]";
    }

    protected String bodyString() {
        return "name=" + this.name + ", category=" + this.category + ", messages=" + this.messages.size();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void setSuspended(boolean f) {
        this.suspended = f;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }
}

