package org.artifact.actor;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;

/**
 * An actor with exception trapping. 
 * 
 * @author BFEIGENB
 *
 */
abstract public class SafeActor extends AbstractActor {
	static final Log log = LogFactory.get(SafeActor.class);
	@Override
	protected void loopBody(Message m) {
		try {
			log.trace("SafeActor loopBody: {}", m);
			doBody((DefaultMessage) m);
		} catch (Exception e) {
			log.error("SafeActor: exception", e);
		}
	}

	@Override
	protected void runBody() {
		// by default, nothing to do
	}

	/**
	 * Override to define message reception behavior. 
	 * 
	 * @param m
	 * @throws Exception
	 */
	abstract protected void doBody(DefaultMessage m) throws Exception;

}