/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.ui;

import com.gogo.common.ui.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ApiModel
public class PageApi<T>
implements Serializable {
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private List<T> records;
    @ApiModelProperty(value="\u54cd\u5e94\u9519\u8bef\u65f6\uff0c\u663e\u793a\u9519\u8bef\u4fe1\u606f")
    private String[] msg;
    @ApiModelProperty(value="\u54cd\u5e94\u4ee3\u7801")
    private int code;
    private Boolean isSuccess;
    @ApiModelProperty(value="\u603b\u8bb0\u5f55\u6570")
    private long allRow;
    @ApiModelProperty(value="\u603b\u9875\u6570")
    private int totalPage;
    @ApiModelProperty(value="\u5f53\u524d\u9875")
    private int currentPage;
    @ApiModelProperty(value="\u6bcf\u9875\u8bb0\u5f55\u6570")
    private int pageSize;
    private int count;
    @ApiModelProperty(value="\u662f\u5426\u7b2c\u4e00\u9875")
    private Boolean isFirstPage;
    @ApiModelProperty(value="\u662f\u5426\u6700\u540e\u4e00\u9875")
    private Boolean isLastPage;
    @ApiModelProperty(value="\u662f\u5426\u6709\u524d\u4e00\u9875")
    private Boolean hasPreviousPage;
    @ApiModelProperty(value="\u662f\u5426\u6709\u4e0b\u4e00\u9875")
    private Boolean hasNextPage;
    @ApiModelProperty(value="\u6392\u5e8f\u5b57\u6bb5")
    private String orderBy;
    private int beginPage;
    private int pageLength;
    private static String[] defaultMsg = new String[]{"\u672a\u77e5\u9519\u8bef"};
    private static int defaultCode = 1000;
    private static int defaultErrorCode = 2000;

    private PageApi() {
    }

    public PageApi(List<T> list, long l2, int n2, int n3) {
        this.records = list;
        this.allRow = l2;
        this.currentPage = n2;
        this.pageSize = n3;
        this.count = list.size();
        this.code = defaultCode;
        this.isSuccess = true;
        this.init();
    }

    public PageApi(List<T> list, long l2, int n2, int n3, String string) {
        this(list, l2, n2, n3);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.orderBy = string;
        }
    }

    public static <T> PageApi<T> success() {
        return PageApi.success(null, 0L, new PageParam());
    }

    public static <T> PageApi<T> success(List<T> list, long l2, PageParam pageParam) {
        int n2 = 1;
        int n3 = 0x7FFFFFFE;
        String string = null;
        if (pageParam != null) {
            n2 = pageParam.getPageNum();
            n3 = pageParam.getPageSize();
            string = pageParam.getOrderBy();
        }
        PageApi<T> pageApi = new PageApi<T>(list, l2, n2, n3, string);
        return pageApi;
    }

    public static <T> PageApi<T> error(String string) {
        String[] stringArray = new String[]{string};
        return PageApi.error(defaultErrorCode, stringArray);
    }

    public static <T> PageApi<T> error(String[] stringArray) {
        return PageApi.error(defaultErrorCode, stringArray);
    }

    public static <T> PageApi<T> error(int n2, String string) {
        String[] stringArray = new String[]{string};
        return PageApi.error(defaultErrorCode, stringArray);
    }

    public static <T> PageApi<T> error(int n2, String[] stringArray) {
        PageApi<T> pageApi = new PageApi<T>();
        pageApi.setCode(n2);
        pageApi.setMsg(stringArray);
        pageApi.setIsSuccess(false);
        return pageApi;
    }

    public void init() {
        this.countCurrentPage();
        this.countTotalPage();
        this.isFirstPage = this.isFirstPage();
        this.isLastPage = this.isLastPage();
        this.hasPreviousPage = this.isHasPreviousPage();
        this.hasNextPage = this.isHasNextPage();
        if (this.currentPage - 4 <= 0) {
            this.beginPage = 1;
        } else if (this.currentPage + 4 >= this.totalPage) {
            this.beginPage = this.totalPage - 8;
            if (this.beginPage <= 0) {
                this.beginPage = 1;
            }
        } else {
            this.beginPage = this.currentPage - 4;
        }
        this.pageLength = this.totalPage - this.beginPage;
        if (this.pageLength >= 8) {
            this.pageLength = 8;
        } else if (this.pageLength < 0) {
            this.pageLength = 0;
        }
    }

    public boolean isFirstPage() {
        return this.currentPage == 1;
    }

    public boolean isLastPage() {
        return this.currentPage == this.totalPage;
    }

    public boolean isHasPreviousPage() {
        return this.currentPage != 1;
    }

    public boolean isHasNextPage() {
        return this.currentPage != this.totalPage;
    }

    public void countTotalPage() {
        this.totalPage = (int)(this.allRow % (long)this.pageSize == 0L ? this.allRow / (long)this.pageSize : this.allRow / (long)this.pageSize + 1L);
    }

    public void countCurrentPage() {
        this.currentPage = this.currentPage == 0 ? 1 : this.currentPage;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> list) {
        this.records = list;
    }

    public String[] getMsg() {
        return this.msg;
    }

    public void setMsg(String[] stringArray) {
        this.msg = stringArray;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n2) {
        this.code = n2;
    }

    public long getAllRow() {
        return this.allRow;
    }

    public void setAllRow(long l2) {
        this.allRow = l2;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int n2) {
        this.totalPage = n2;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int n2) {
        this.currentPage = n2;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n2) {
        this.pageSize = n2;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String string) {
        this.orderBy = string;
    }

    public int getBeginPage() {
        return this.beginPage;
    }

    public void setBeginPage(int n2) {
        this.beginPage = n2;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public void setPageLength(int n2) {
        this.pageLength = n2;
    }

    public Boolean isSuccess() {
        return this.isSuccess;
    }

    public void setIsSuccess(Boolean bl) {
        this.isSuccess = bl;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n2) {
        this.count = n2;
    }
}

