/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.mvc.controller;

import com.auth0.jwt.exceptions.JWTCreationException;
import com.gogo.common.tools.ConfigUtils;
import com.gogo.common.tools.JwtUtils;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class BaseController {
    protected final String REDIRECT = "redirect:";
    protected static final Integer pageSize = 10;

    protected void setUserInfo(HttpSession httpSession, Object object, long l2, String string) {
        if (httpSession == null) {
            throw new RuntimeException("The parameter \"session\" that must be available!");
        }
        httpSession.setAttribute("user", object);
        httpSession.setAttribute("userId", (Object)l2);
        httpSession.setAttribute("username", (Object)string);
    }

    protected Object getUser(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        return this.getUser(httpServletRequest.getSession());
    }

    protected Object getUser(HttpSession httpSession) {
        if (httpSession == null) {
            throw new RuntimeException("The parameter \"session\" that must be available!");
        }
        Object object = httpSession.getAttribute("user");
        return object;
    }

    protected void removeUserInfo(HttpSession httpSession) {
        if (httpSession == null) {
            throw new RuntimeException("The parameter \"session\" that must be available!");
        }
        httpSession.removeAttribute("user");
        httpSession.removeAttribute("userId");
        httpSession.removeAttribute("username");
    }

    protected String getToken(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        String string = ConfigUtils.getPropertyValue("authorization.header.name");
        String string2 = ConfigUtils.getPropertyValue("authorization.header.start");
        String string3 = httpServletRequest.getHeader(string);
        if (StringUtils.isBlank((CharSequence)string3) || !string3.startsWith(string2)) {
            throw new IllegalArgumentException("\u83b7\u53d6token\u5931\u8d25\uff01");
        }
        String string4 = string3.substring(string2.length());
        return string4;
    }

    protected String getUserName(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        return this.getUserName(httpServletRequest.getSession());
    }

    protected Long getUserId(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        return this.getUserId(httpServletRequest.getSession());
    }

    protected long getUserIdByToken(HttpServletRequest httpServletRequest) throws Exception {
        String string = this.getToken(httpServletRequest);
        long l2 = JwtUtils.getPoint(string);
        return l2;
    }

    protected String putToken(HttpServletResponse httpServletResponse, Long l2) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
        String string = ConfigUtils.getPropertyValue("authorization.header.name");
        String string2 = ConfigUtils.getPropertyValue("authorization.header.start");
        String string3 = JwtUtils.createToken(l2);
        httpServletResponse.addHeader(string, string2 + string3);
        httpServletResponse.addHeader("Access-Control-Expose-Headers", string);
        return string3;
    }

    protected String putToken(HttpServletResponse httpServletResponse, Long l2, String[] stringArray) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
        String string = ConfigUtils.getPropertyValue("authorization.header.name");
        String string2 = ConfigUtils.getPropertyValue("authorization.header.start");
        String string3 = JwtUtils.createToken(l2, stringArray);
        httpServletResponse.addHeader(string, string2 + string3);
        httpServletResponse.addHeader("Access-Control-Expose-Headers", string);
        return string3;
    }

    protected String getUserName(HttpSession httpSession) {
        if (httpSession == null) {
            throw new RuntimeException("The parameter \"session\" that must be available!");
        }
        Object object = httpSession.getAttribute("username");
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    protected Long getUserId(HttpSession httpSession) {
        if (httpSession == null) {
            throw new RuntimeException("The parameter \"session\" that must be available!");
        }
        Object object = httpSession.getAttribute("userId");
        if (object != null) {
            return Long.valueOf(object.toString());
        }
        return null;
    }

    protected String getHost(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        String string = "";
        int n2 = httpServletRequest.getServerPort();
        if (n2 != 80 && n2 != 443) {
            string = ":" + n2;
        }
        String string2 = httpServletRequest.getScheme();
        String string3 = httpServletRequest.getServerName();
        String string4 = httpServletRequest.getContextPath();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("://").append(string3).append(string).append(string4);
        return stringBuffer.toString();
    }

    protected String getUserAgent(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new RuntimeException("The parameter \"request\" that must be available!");
        }
        return httpServletRequest.getHeader("User-Agent");
    }
}

