/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.mvc.configuration;

import com.gogo.common.mvc.configuration.properties.ThreadPoolProperties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class ThreadPoolConfiguration {
    @Autowired
    private ThreadPoolProperties threadPoolProperties;

    @Bean(name={"threadPool"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.threadPoolProperties.getCorePoolSize().intValue());
        threadPoolTaskExecutor.setMaxPoolSize(this.threadPoolProperties.getMaxPoolSize().intValue());
        threadPoolTaskExecutor.setQueueCapacity(this.threadPoolProperties.getQueueCapacity().intValue());
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut(this.threadPoolProperties.getAllowCoreThreadTimeOut().booleanValue());
        threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return threadPoolTaskExecutor;
    }
}

