/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.mvc.aspect.paginator;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class PaginatorAspect {
    @Around(value="@annotation(com.gogo.common.mvc.aspect.paginator.annotation.Paginator)")
    public Object paginator(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object = proceedingJoinPoint.proceed();
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map<String, Object> map = this.a(httpServletRequest);
        String string = JSON.toJSONString(map);
        Signature signature = proceedingJoinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        ResponseBody responseBody = method.getAnnotation(ResponseBody.class);
        if (responseBody == null) {
            httpServletRequest.setAttribute("params", map);
            httpServletRequest.setAttribute("paramsJson", (Object)string);
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            map2.put("params", map);
            map2.put("paramsJson", string);
        }
        return object;
    }

    private Map<String, Object> a(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getParameter(string);
            if (StringUtils.isBlank((CharSequence)string2) || "page".equals(string)) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

