/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.mvc.aspect.caching;

import com.gogo.common.mvc.aspect.caching.annotation.CacheAvl;
import com.gogo.common.mvc.aspect.caching.annotation.CacheDel;
import com.gogo.common.tools.DateUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class CachingAspect {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    @Around(value="@annotation(com.gogo.common.mvc.aspect.caching.annotation.CacheAvl) || @annotation(com.gogo.common.mvc.aspect.caching.annotation.CacheDel)")
    public Object caching(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Signature signature = proceedingJoinPoint.getSignature();
        Object[] objectArray = proceedingJoinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Object object = null;
        CacheAvl cacheAvl = method.getAnnotation(CacheAvl.class);
        CacheDel cacheDel = method.getAnnotation(CacheDel.class);
        if (cacheAvl != null) {
            String string;
            String string2 = cacheAvl.key();
            String string3 = cacheAvl.hKey();
            if (null != objectArray && objectArray.length > 1) {
                if (StringUtils.isNotEmpty((CharSequence)string2) && string2.startsWith("#")) {
                    string2 = String.valueOf(objectArray[0]);
                }
                if (StringUtils.isNotEmpty((CharSequence)string3) && string3.startsWith("#")) {
                    string3 = String.valueOf(objectArray[1]);
                }
            }
            long l2 = cacheAvl.timeout();
            TimeUnit timeUnit = cacheAvl.timeUnit();
            String string4 = cacheAvl.expireAt();
            String string5 = cacheAvl.format();
            boolean bl = cacheAvl.freshExpire();
            if (StringUtils.isNotBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string2)) {
                throw new Exception("key, expireAt\u5fc5\u987b\u540c\u65f6\u8bbe\u7f6e\u3002");
            }
            if (StringUtils.isNotBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5)) {
                throw new Exception("expireAt, format\u5fc5\u987b\u540c\u65f6\u8bbe\u7f6e\u3002");
            }
            if (StringUtils.isBlank((CharSequence)string2)) {
                string2 = proceedingJoinPoint.getTarget().getClass().getName();
            }
            if (StringUtils.isBlank((CharSequence)string3)) {
                string = Arrays.toString(proceedingJoinPoint.getArgs());
                string3 = signature.toLongString() + string;
            }
            if ((object = (string = this.redisTemplate.boundHashOps((Object)string2)).get((Object)string3)) == null) {
                object = proceedingJoinPoint.proceed();
                string.put((Object)string3, object);
                if (l2 > 0L) {
                    string.expire(l2, timeUnit);
                }
                if (StringUtils.isNotBlank((CharSequence)string4)) {
                    Date date = DateUtil.str2Date(string4, string5);
                    string.expireAt(date);
                }
            }
            if (bl) {
                string.expire(l2, timeUnit);
            }
        } else if (cacheDel != null) {
            object = proceedingJoinPoint.proceed();
            String string = cacheDel.key();
            if (StringUtils.isBlank((CharSequence)string)) {
                string = proceedingJoinPoint.getTarget().getClass().getName();
            }
            this.redisTemplate.delete((Object)string);
        } else {
            object = proceedingJoinPoint.proceed();
        }
        return object;
    }
}

