/*
 * Decompiled with CFR 0.152.
 */
package com.gogo.common.enums;

import org.apache.commons.lang3.StringUtils;

public enum DBTypeEnum {
    SQLSERVER("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://${ip}:${port};DatabaseName=${dbName}"),
    ACCESS_REMOTE("access_remote", "org.objectweb.rmijdbc.Driver", "jdbc:rmi://${ip}/jdbc:odbc:${dbName}"),
    ACCESS("access", "net.ucanaccess.jdbc.UcanaccessDriver", "jdbc:ucanaccess:///${dbName}"),
    MYSQL("mysql", "", "");

    private String code;
    private String driverClass;
    private String url;

    private DBTypeEnum(String string2, String string3, String string4) {
        this.code = string2;
        this.driverClass = string3;
        this.url = string4;
    }

    public void check(String string, String string2, String string3, String string4, String string5) {
        if (this.getCode().equals(ACCESS_REMOTE.getCode())) {
            if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string3)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f: db.ip, db.name");
            }
        } else if (this.getCode().equals(SQLSERVER.getCode())) {
            if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2) || StringUtils.isBlank((CharSequence)string3) || StringUtils.isBlank((CharSequence)string4) || StringUtils.isBlank((CharSequence)string5)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f: db.ip, db.port, db.name, db.username, dbPassword");
            }
        } else if (this.getCode().equals(ACCESS.getCode()) && string3.indexOf("/") == -1 && string3.indexOf("\\") == -1) {
            throw new IllegalArgumentException("\u8bbf\u95ee\u672c\u5730Access\u6570\u636e\u5e93\u65f6\uff0cdbName\u5fc5\u987b\u662f\u5168\u8def\u5f84\u3002");
        }
    }

    public String getUrl(String string, String string2, String string3) {
        String string4 = this.getUrl();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string4 = string4.replace("${ip}", string);
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            string4 = string4.replace("${port}", string2);
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            string4 = string4.replace("${dbName}", string3);
        }
        return string4;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String string) {
        this.driverClass = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }
}

