package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

import com.gogo.common.ui.ZipLayer;

/**
 * 文件压缩工具包
 * @author momo
 * @since 2018-8-8
 */
public class ZipUtil1 {

    /**
     * 批量文件流压缩
     * @author momo
     * @since 2018-8-9
     * @param baisBytes
     * @return 压缩后字节数组输出流转为的字符串
     * @throws IOException
     */
    public static byte[] zip(List<ZipLayer> files) throws IOException {
        //1.创建字节数组输出流，用于返回压缩后的输出流字节数组
        ByteArrayOutputStream baos = null;
        //2.创建压缩输出流
        ZipOutputStream zipOut = null;
        try {
        	baos = new ByteArrayOutputStream();
        	zipOut = new ZipOutputStream(baos);
        	zipOut.setEncoding("UTF8");//设置编码格式，否则中文文件名乱码
	        //3.遍历要批量压缩的集合文件流
        	try {
        		for(ZipLayer file : files) {
        			String folder = file.getFolderInZip();
    	        	FileInputStream fis = null;
    	        	try {
    	            	if(folder.indexOf("/") == -1) {
    	            		throw new IllegalArgumentException("文件夹请使用双引号来分割！");
    	            	}
    	            	if(!folder.endsWith("/")) {
    	            		folder = folder+"/";
    	            	}
    	            	if(!folder.startsWith("/")) {
    	            		folder = "/"+folder;
    	            	}
    	            	String path = file.getPath();
    	            	String innerPath = folder+file.getFileName();
    	            	
    	            	fis = new FileInputStream(path);
    	            	
    	            	zipOut.putNextEntry(new ZipEntry(innerPath));
    	            	byte[] byteArray = IOUtils.toByteArray(fis);
    	            	zipOut.write(byteArray);
    				} finally {
    					if(fis != null) {
    						fis.close();
    					}
    				}
    	        }
			} finally {
				if(zipOut != null) {
					zipOut.closeEntry();
			        zipOut.close();
				}
			}
	        return baos.toByteArray();
        } finally {
        	if(baos != null) {
        		baos.close();
			}
		}
    }

}