package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.gogo.common.http.HttpUtils;
import com.gogo.common.tools.DateUtil;
import com.gogo.common.tools.StringUtil;
import com.gogo.common.ui.Zillow.Searchresults;

import cn.hutool.core.collection.CollectionUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ZillowUtils1 {
	private static String getUrl(Integer streetNum, String streetName, String unit, Integer zipCode) throws UnsupportedEncodingException {
		StringBuilder sb = new StringBuilder("http://www.zillow.com/webservice/GetSearchResults.htm?");
		sb.append("zws-id").append("=").append("X1-ZWz17h88cq93pn_5taq0").append("&")
			.append("address").append("=").append(URLEncoder.encode(streetNum + " " + streetName + " " + unit, "utf-8")).append("&")
			.append("citystatezip").append("=").append(zipCode);
		return sb.toString();
	}
	
	public static Searchresults get(Integer streetNum, String streetName, String unit, Integer zipCode) throws Exception {
		String url = getUrl(streetNum, streetName, unit, zipCode);
		String httpGet = HttpUtils.httpGet(url);
		ByteArrayInputStream in = null;
    	try {
    		SAXReader reader = new SAXReader();
    		in = new ByteArrayInputStream(httpGet.getBytes("UTF-8"));
    		Document doc = reader.read(in);
    		if(doc == null) {
    			return null;
    		}
    		
    		 Element root = doc.getRootElement(); 
    		 return new Searchresults(root);
		} finally {
			if(in != null) {
				in.close();
			}
		}
	}
	
}
