package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.gogo.common.tools.Utils;

import lombok.Data;
import oth.syk.common.http.HttpUtils1;

public class XmlUtils1 {
	
//	public static void main(String[] args) throws Exception {
////		String url = "http://www.zillow.com/webservice/GetSearchResults.htm?zws-id=X1-ZWz17h88cq93pn_5taq0&address=17646+Blythe+Way&citystatezip=92225";
////		String httpGet = HttpUtils1.httpGet(url);
////		tet(httpGet);
//		String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><SearchResults:searchresults xsi:schemaLocation=\"http://www.zillow.com/static/xsd/SearchResults.xsd http://www.zillowstatic.com/vstatic/80d5e73/static/xsd/SearchResults.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SearchResults=\"http://www.zillow.com/static/xsd/SearchResults.xsd\"><request><address>17646 Blythe Way</address><citystatezip>92225</citystatezip></request><message><text>Request successfully processed</text><code>0</code></message><response><results><result><zpid>18156939</zpid><links><homedetails>http://www.zillow.com/homedetails/17646-Blythe-Way-Blythe-CA-92225/18156939_zpid/</homedetails><graphsanddata>http://www.zillow.com/homedetails/17646-Blythe-Way-Blythe-CA-92225/18156939_zpid/#charts-and-data</graphsanddata><mapthishome>http://www.zillow.com/homes/18156939_zpid/</mapthishome><comparables>http://www.zillow.com/homes/comps/18156939_zpid/</comparables></links><address><street>17646 Blythe Way</street><zipcode>92225</zipcode><city>Blythe</city><state>CA</state><latitude>33.60318</latitude><longitude>-114.720687</longitude></address><zestimate><amount currency=\"USD\">116435</amount><last-updated>04/28/2021</last-updated><oneWeekChange deprecated=\"true\"></oneWeekChange><valueChange></valueChange><valuationRange><low currency=\"USD\">90819</low><high currency=\"USD\">144379</high></valuationRange><percentile>0</percentile></zestimate><localRealEstate><region name=\"Blythe\" id=\"3719\" type=\"city\"><links><overview>http://www.zillow.com/local-info/CA-Blythe/r_3719/</overview><forSaleByOwner>http://www.zillow.com/blythe-ca/fsbo/</forSaleByOwner><forSale>http://www.zillow.com/blythe-ca/</forSale></links></region></localRealEstate></result></results></response></SearchResults:searchresults><!-- H:001  T:41ms  S:869  R:Wed Apr 28 19:32:21 PDT 2021  B:5.0.67111-master.dafcd5b~qa.83389e5b -->";
//		tet(xml);
//	}
	
	private static boolean hasChildren(Element element) {
		List<Element> elements = element.elements();
		if(elements.size() > 0) {
			return true;
		}
		return false;
	}
	
	@SuppressWarnings("deprecation")
	public static <T, P> void nomal(Element element, P p, T t) throws Exception {
		if(!element.hasContent()) {
			return;
		}
		if(hasChildren(element)) {
			List<Element> elements = element.elements();
			for(Element e : elements) {
				if(hasChildren(e)) {
					Field field = null;
					try {
						field = t.getClass().getDeclaredField(e.getName());
					} catch (NoSuchFieldException e2) {
						continue;
					}
					if(field.getType().isArray()) {
						//todo
					}
					Object newInstance = field.getType().getDeclaredConstructor().newInstance();
					nomal(e, t, newInstance);
				}else {
					Utils.setValToned(e.getName(), e.getText(), t);
				}
			}
		}else {
			Utils.setVal(element.getName(), element.getText(), p);
		}
	}
	
//	@SuppressWarnings("deprecation")
//	private static String jio(Element element, Class<?> cls) {
//		List<Element> list = element.elements();
//		if(element.hasContent()) {
//			if(list.size() == 0) {
//				Field[] fields = cls.getDeclaredFields();
//				for(Field field : fields) {
//					String name = field.getName();
//					Element child = element.element(name);
//					Class<?> type = field.getType();
//				}
//	        	String name = element.getName();
//	        	String text = element.getText();
//	        	T t = cls.newInstance();
//	        	Utils1.setVal(name, text, t);
//	        }else {
//	        	jio(e);
//	        }
//		}else {
//			return null;
//		}
//        
//		
//		
//		T t = cls.newInstance();
//		String fieldName = element.getName();
//	    for (Iterator<Element> iterator = element.elementIterator(); iterator.hasNext();) {
//	        Element e = iterator.next();
//	        
//	        System.out.println(e.getName() + "- " + e.getText() + " - " + e.hasContent());
//	    }
//	    return t;
//	}
	
	public static void tet(String xmlStr) throws Exception {
		ByteArrayInputStream in = null;
    	try {
    		SAXReader reader = new SAXReader();
    		in = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
    		Document doc = reader.read(in);
    		if(doc == null) {
    			return;
    		}
    		Searchresults s = new Searchresults();
    		nomal(doc.getRootElement(), null, s);
		} finally {
			if(in != null) {
				in.close();
			}
		}
	}
	
	@Data
	public static class Searchresults {
		private Message message;
		private Response response;
	}
	
	@Data
	public static class Response {
		private List<Result> results;
	}
	
	@Data
	public static class Message{
		private String text;
		private Integer code;
	}
	
	@Data
	public static class Result{
		private Zestimate zestimate;
	}
	
	@Data
	public static class Zestimate {
		private Integer amount;
		private Date lastUpdated;
		private ValuationRange valuationRange;
		private Integer percentile;
	}
	
	@Data
	public static class ValuationRange {
		private Integer low;
		private Integer high;
	}
}
