package oth.syk.common.tools;

import java.security.Key;
import java.security.Security;
import java.util.Map;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

import com.alibaba.fastjson.JSON;
import com.gogo.common.http.HttpUtils;
import com.gogo.common.ui.WeChat;

import lombok.extern.slf4j.Slf4j;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import oth.syk.common.http.HttpClient;
import oth.syk.common.http.HttpUtils1;
import okhttp3.Request.Builder;

@Slf4j
public class WechatUtils1 {
	
	public static boolean initialized = false;
	
	/**
	 * 小程序中获取用户信息
	 * @param appid
	 * @param secret
	 * @param breakCode
	 * @return
	 * @throws Exception
	 */
	public static WeChat.session getUserSession(String appid, String secret, String breakCode) throws Exception {
		String url = "https://api.weixin.qq.com/sns/jscode2session?appid="+appid+"&secret="+secret+"&js_code="+breakCode+"&grant_type=authorization_code";
		String value = HttpUtils1.httpGet(url);
		log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>WechatUtils.getUserSession: "+ value);
		WeChat.session weChatSession = JSON.parseObject(value, WeChat.session.class);
		return weChatSession;
	}
	
	/**
	 * 微信支付（预支付）
	 * @param xmlParams
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("deprecation")
	public static Map<String, Object> prePay(String xmlParams) throws Exception {
		String prePayUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
		HttpClient httpClient = HttpUtils1.getHttpClient();
		MediaType mediaType = MediaType.parse("text/xml;charset=UTF-8");
		RequestBody body = RequestBody.create(mediaType, xmlParams);
		Builder builder = new Request.Builder().url(prePayUrl);
		if (body != null) {
			builder.post(body);
		}
		Request request = builder.build();
		Response response = httpClient.execute(request);
		if (!response.isSuccessful()) {
			throw new IllegalStateException("微信预支付失败，code: "+response.code()+".  message: "+response.message());
		}
		String string = response.body().string();
		log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>WechatUtils.prePay: "+ string);
		Map<String, Object> map = StringUtil1.xmlStr2Map(string);
		
		return map;
	}
	
	/**
	 * 从小程序的加密字符中解密用户信息（包含unionid）
	 * @param encryptDataB64
	 * @param sessionKeyB64
	 * @param ivB64
	 * @return
	 * @throws Exception 
	 */
	public static String decryptData(String encryptDataB64, String sessionKeyB64, String ivB64) throws Exception {
		byte[] encryptedData = Base64.decode(encryptDataB64);
		byte[] keyBytes = Base64.decode(sessionKeyB64);
		byte[] ivs = Base64.decode(ivB64);
		
		Key key = init(keyBytes);
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        cipher.init(Cipher.DECRYPT_MODE, key, new IvParameterSpec(ivs));
        byte[] doFinal = cipher.doFinal(encryptedData);
		
        String decryptData = new String(doFinal);
        decryptData = decryptData.replace("result = ", "");
		return decryptData;
    }

    /**
     * 服务号中获取用户信息（包含unionid）
     * @param accessToken
     * @param ffhOpenId
     * @return
     * @throws Exception
     */
    public static String getUserInfo(String accessToken, String ffhOpenId) throws Exception {
    	String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token="+accessToken+"&openid="+ffhOpenId+"&lang=zh_CN";
    	String value = HttpUtils.httpGet(url);
		log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>WechatUtils.getUserInfo: "+ value);
		return value;
    }
    
    /**
     * 获取accessToken
     * @param appid
     * @param secret
     * @return
     * @throws Exception
     */
    public static WeChat.token getAccessToken(String appid, String secret) throws Exception {
		String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="+appid+"&secret="+secret;
		String value = HttpUtils.httpGet(url);
		return JSON.parseObject(value, WeChat.token.class);
    }
    
    public static String sendModelMessage(String accessToken, WeChat.modelMsg message) throws Exception {
    	String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="+accessToken;
    	if(StringUtils.isBlank(message.getTouser())) {
    		throw new IllegalArgumentException("touser不能为空！");
    	}
    	if(StringUtils.isBlank(message.getTemplate_id())) {
    		throw new IllegalArgumentException("template_id不能为空！");
    	}
    	return HttpUtils.jsonPost(url, message);
    }
    
    private static Key init(byte[] keyBytes) throws Exception {
        // 如果密钥不足16位，那么就补足.  这个if 中的内容很重要
        int base = 16;
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte) 0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        
        // 初始化
        if (!initialized) {
        	Security.addProvider(new BouncyCastleProvider());    
        	initialized = true;
        }
        // 转化成JAVA的密钥格式
        return new SecretKeySpec(keyBytes, "AES");
    }
    
}
