package oth.syk.common.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.util.ObjectUtils;

public class VOUtils1 {

	public static <V> V po2vo(Object po, Class<V> clazz) throws Exception {
		if (ObjectUtils.isEmpty(po)) {
			return null;
		}
		V vo = clazz.newInstance();
		BeanUtils.copyProperties(vo, po);
		try {
			Method method  = clazz.getMethod("parse");
			method.setAccessible(true);
			method.invoke(vo);
		} catch (NoSuchMethodException e) {
		}
		return vo;
	}

	public static <P, V> List<V> po2vo(List<P> content, Class<V> clazz) throws Exception {
		List<V> newContent = new ArrayList<V>();
		if (content != null && content.size() > 0) {
			for (P po : content) {
				V vo = po2vo(po, clazz);
				newContent.add(vo);
			}
		}
		return newContent;
	}

}
