package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.gogo.common.constants.RegexConstant;
import com.gogo.common.enums.DayTimeEnum;
import com.gogo.common.ui.DBInfo;
import com.gogo.common.ui.Over;
import com.gogo.common.ui.ResetDayTime;

import lombok.Data;

public class Utils1 {
	private static final Logger LOG = LoggerFactory.getLogger(Utils1.class);
	private static final Number BigDecimal = null;
	
	/**
	 * 判断一个类是否为基本数据类型。
	 * 
	 * @param clazz
	 *            要判断的类。
	 * @return true 表示为基本数据类型。
	 */
	public static boolean isMinimumType(Class<?> clazz) {
		return (clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class)
				|| clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class)
				|| clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class)
				|| clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class));
	}
	
	public static boolean isMinimumType(Object obj) {
		return (obj instanceof String || obj instanceof Integer || obj instanceof Byte 
				|| obj instanceof Long || obj instanceof Double || obj instanceof Float
				|| obj instanceof Character || obj instanceof Short || obj instanceof BigDecimal
				|| obj instanceof BigInteger || obj instanceof Boolean || obj instanceof Date);
	}
	
	public static byte[] objectToByte(Object obj) throws IOException {  
	    try (ByteArrayOutputStream bo = new ByteArrayOutputStream();
	    		ObjectOutputStream oo = new ObjectOutputStream(bo); ) {
	    	byte[] bytes = null;
	        oo.writeObject(obj);
	        bytes = bo.toByteArray();
	        return bytes;  
	    }
	}
	
	public static Object byteToObject(byte[] bytes) {
		Object obj = null;
		try (ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
				ObjectInputStream oi = new ObjectInputStream(bi);) {
	
			obj = oi.readObject();
			bi.close();
			oi.close();
		} catch (Exception e) {
			System.out.println("translation" + e.getMessage());
			e.printStackTrace();
		}
        return obj;
    }
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static <T> T getChange(Class<T> cls, T newObj, T old) throws Exception {
    	Field[] fields = cls.getDeclaredFields();
    	T change = cls.newInstance();
    	boolean flag = false;
    	for(Field field : fields) {
    		field.setAccessible(true);
    		Object newVal = field.get(newObj);
    		Object oldVal = field.get(old);
    		if(newVal == null) {
    			continue;
    		}
    		Class type = field.getType();
    		if(!Utils1.isMinimumType(type)) {
    			Object innerChange = Utils1.getChange(type, newVal, oldVal);
    			if(innerChange != null) {
    				flag = true;
        			field.set(change, newVal);
    			}
    		}else if(newVal != oldVal) {
    			flag = true;
    			field.set(change, newVal);
    		}
    	}
    	if(flag) {
    		return change;
    	}
    	return null;
    }
	
	/**  
     * 生成32位编码  
     * @return string  
     */    
    public static String getUUID(){
        String uuid = UUID.randomUUID().toString().trim().replaceAll("-", "");
        return uuid;
    }
	
	public static String unicode2Chinese(String unicode){
		String newStr = null;
		try {
			newStr = URLDecoder.decode(unicode,"UTF-8");
		} catch (UnsupportedEncodingException e) {
			LOG.error("",e);
		}
		return newStr;
	}
	
	
	/** 
     * 将数字转换成中文数字 
     * @author Prosper 
     * 
     */  
    public static String int2ChineseNumber(String i){
    	Matcher m = Pattern.compile(RegexConstant.cn_number).matcher(i);
    	if(m.find()){
    		return i;
    	}
        String[] zh = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};    
        String[] unit = {"", "十", "百", "千", "万", "十", "百", "千", "亿", "十"};    
          
        String str = "";  
        StringBuffer sb = new StringBuffer(i);  
        sb = sb.reverse();  
        int r = 0;  
        int l = 0;  
        for (int j = 0; j < sb.length(); j++)  
        {  
            /** 
             * 当前数字 
             */  
            r = Integer.valueOf(sb.substring(j, j+1));  
              
            if (j != 0)  
                /** 
                 * 上一个数字 
                 */  
                l = Integer.valueOf(sb.substring(j-1, j));  
              
            if (j == 0)  
            {  
                if (r != 0 || sb.length() == 1)  
                    str = zh[r];  
                continue;  
            }  
              
            if (j == 1 || j == 2 || j == 3 || j == 5 || j == 6 || j == 7 || j == 9)  
            {  
                if (r != 0)  
                    str = zh[r] + unit[j] + str;  
                else if (l != 0)  
                    str = zh[r] + str;  
                continue;  
            }  
              
            if (j == 4 || j == 8)  
            {  
                str =  unit[j] + str;  
                if ((l != 0 && r == 0) || r != 0)  
                    str = zh[r] + str;  
                continue;  
            }  
        }  
        return str;  
    } 
	
	public static int chineseNumber2Int(String chineseNumber){
		Matcher m = Pattern.compile("^\\d+$").matcher(chineseNumber);
		if(m.find()){
			return Integer.valueOf(chineseNumber);
		}
		int result = 0;
		int temp = 1;//存放一个单位的数字如：十万
		int count = 0;//判断是否有chArr
		char[] cnArr = new char[]{'一','二','三','四','五','六','七','八','九'};
		char[] chArr = new char[]{'十','百','千','万','亿'};
		for (int i = 0; i < chineseNumber.length(); i++) {
			boolean b = true;//判断是否是chArr
			char c = chineseNumber.charAt(i);
			for (int j = 0; j < cnArr.length; j++) {//非单位，即数字
				if (c == cnArr[j]) {
					if(0 != count){//添加下一个单位之前，先把上一个单位值添加到结果中
						result += temp;
						temp = 1;
						count = 0;
					}
					// 下标+1，就是对应的值
					temp = j + 1;
					b = false;
					break;
				}
			}
			if(b){//单位{'十','百','千','万','亿'}
				for (int j = 0; j < chArr.length; j++) {
					if (c == chArr[j]) {
						switch (j) {
						case 0:
							temp *= 10;
							break;
						case 1:
							temp *= 100;
							break;
						case 2:
							temp *= 1000;
							break;
						case 3:
							temp *= 10000;
							break;
						case 4:
							temp *= 100000000;
							break;
						default:
							break;
						}
						count++;
					}
				}
			}
			if (i == chineseNumber.length() - 1) {//遍历到最后一个字符
				result += temp;
			}
		}
		return result;
	}
	
	public static String encode(String str, String charset) {
		StringBuffer b = new StringBuffer();
		try {
			String zhPattern = "[\u4e00-\u9fa5]+|[\\[\\]]|\\s";
			Pattern p = Pattern.compile(zhPattern);
			Matcher m = p.matcher(str);
			while (m.find()) {
				m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
			}
			m.appendTail(b);
		} catch (Exception e) {
			LOG.error("",e);
		}
		return b.toString();
	}
	
	public static boolean containsOne(List<String> all, List<String> sub){
		for(String s : sub){
			if(all.contains(s)){
				return true;
			}
		}
		return false;
	}
	
	public static String getHostUrl(String host, String uri){
		if(!uri.startsWith("http://") && !uri.startsWith("https://")){
			if(!uri.startsWith("/")){
				uri = "/"+uri;
			}
			uri = host+uri;
		}
		return uri;
	}
	
	//base64编码
	public static String base64(String str, String charset) throws UnsupportedEncodingException{
		byte[] data = str.getBytes(charset);
		
		char[] base64EncodeChars = new char[] { 
	        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 
	        'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 
	        'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 
	        'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 
	        'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 
	        'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 
	        'w', 'x', 'y', 'z', '0', '1', '2', '3', 
	        '4', '5', '6', '7', '8', '9', '+', '/' }; 
		
        StringBuffer sb = new StringBuffer(); 
        int len = data.length; 
        int i = 0; 
        int b1, b2, b3; 
        while (i < len) { 
            b1 = data[i++] & 0xff; 
            if (i == len) 
            { 
                sb.append(base64EncodeChars[b1 >>> 2]); 
                sb.append(base64EncodeChars[(b1 & 0x3) << 4]); 
                sb.append("=="); 
                break; 
            } 
            b2 = data[i++] & 0xff; 
            if (i == len) 
            { 
                sb.append(base64EncodeChars[b1 >>> 2]); 
                sb.append(base64EncodeChars[((b1 & 0x03) << 4) | ((b2 & 0xf0) >>> 4)]); 
                sb.append(base64EncodeChars[(b2 & 0x0f) << 2]); 
                sb.append("="); 
                break; 
            } 
            b3 = data[i++] & 0xff; 
            sb.append(base64EncodeChars[b1 >>> 2]); 
            sb.append(base64EncodeChars[((b1 & 0x03) << 4) | ((b2 & 0xf0) >>> 4)]); 
            sb.append(base64EncodeChars[((b2 & 0x0f) << 2) | ((b3 & 0xc0) >>> 6)]); 
            sb.append(base64EncodeChars[b3 & 0x3f]); 
        } 
        String encoded = sb.toString(); 
        return encoded;    
	}
	
	@SuppressWarnings({ "unchecked"})
	public static <T, V> Map<T, V> getMap(List<V> list, String keyField) throws Exception{
		HashMap<T, V> map = new HashMap<T, V>();
		if(list != null) {
			for(V v : list) {
				Class<? extends Object> clazz = v.getClass();
				Field field = clazz.getDeclaredField(keyField);
				field.setAccessible(true);
				Object obj = field.get(v);
				T t = null;
				if(obj != null) {
					t = (T) obj;
				}
				map.put(t, v);
			}
		}
		return map;
	}
	
	@SuppressWarnings({ "unchecked"})
	public static <T, V> Map<T, List<V>> getMapListVal(List<V> list, String keyField) throws Exception{
		HashMap<T, List<V>> map = new HashMap<T, List<V>>();
		if(list != null) {
			for(V v : list) {
				Class<? extends Object> clazz = v.getClass();
				Field field = clazz.getDeclaredField(keyField);
				field.setAccessible(true);
				Object obj = field.get(v);
				T t = null;
				if(obj != null) {
					t = (T) obj;
				}
				List<V> listVal = map.get(t);
				if(listVal == null) {
					listVal = new ArrayList<V>();
					map.put(t, listVal);
				}
				listVal.add(v);
			}
		}
		return map;
	}
	
	@SuppressWarnings("unchecked")
	public static <V, O> V getVal(String key, O o) throws Exception{
		Class<? extends Object> clazz = o.getClass();
		Field field = clazz.getDeclaredField(key);
		field.setAccessible(true);
		Object obj = field.get(o);
		V v = null;
		if(obj != null) {
			v = (V) obj;
		}
		return v;
	}
	
	public static <O> void setVal(String key, Object v, O o) throws Exception {
		Class<? extends Object> clazz = o.getClass();
		Field field = clazz.getDeclaredField(key);
		field.setAccessible(true);
		field.set(o, v);
	}
	
	public static <O> void setValToned(String key, Object v, O o) throws Exception {
		Class<? extends Object> clazz = o.getClass();
		Field field = clazz.getDeclaredField(key);
		field.setAccessible(true);
		Class<?> type = field.getType();
		field.set(o, convert(v, type));
	}
	
	@SuppressWarnings({ "deprecation", "unchecked" })
	public static <T> T convert(Object obj, Class<?> type) throws ParseException {
		if (obj == null || StringUtils.isBlank(obj.toString())) {
			return null;
		}
        if (type.equals(Integer.class)||type.equals(int.class)) {
            return (T)new Integer(obj.toString());
        } else if (type.equals(Long.class)||type.equals(long.class)) {
            return (T)new Long(obj.toString());
        } else if (type.equals(Boolean.class)||type.equals(boolean.class)) {
            return (T) new Boolean(obj.toString());
        } else if (type.equals(Short.class)||type.equals(short.class)) {
            return (T) new Short(obj.toString());
        } else if (type.equals(Float.class)||type.equals(float.class)) {
            return (T) new Float(obj.toString());
        } else if (type.equals(Double.class)||type.equals(double.class)) {
            return (T) new Double(obj.toString());
        } else if (type.equals(Byte.class)||type.equals(byte.class)) {
            return (T) new Byte(obj.toString());
        } else if (type.equals(Character.class)||type.equals(char.class)) {
            return (T)new Character(obj.toString().charAt(0));
        } else if (type.equals(String.class)) {
            return (T) obj;
        } else if (type.equals(BigDecimal.class)) {
            return (T) new BigDecimal(obj.toString());
        } else if (type.equals(LocalDateTime.class)) {
            return (T) LocalDateTime.parse(obj.toString());
        } else if (type.equals(Date.class)) {
        	return (T) DateUtil1.str2Date(obj.toString());
        }else{
            return null;
        }
	}
	
	public static <T> List<List<T>> groupList(List<T> list, int groupSize) {
		if(list == null || list.size() == 0) {
			return null;
		}
		List<List<T>> total = new ArrayList<List<T>>();
		for(T t : list) {
			if(total.size() == 0) {
				total.add(new ArrayList<T>());
			}
			List<T> group = total.get(total.size()-1);
			if(group.size() >= groupSize) {
				group = new ArrayList<T>();
				total.add(group);
			}
			group.add(t);
		}
		return total;
	}
	
	/**
	 * 获取一天的时间范围（一天从什么时候开始，到什么时候结束）
	 * @param date  指定哪一天
	 * @param dayTime 开始结束的范围
	 * @param addDay 在指定的基础上增减一天
	 * @return
	 * @throws ParseException
	 */
	public static ResetDayTime getDayTime(Date date, DayTimeEnum dayTime, int addDay) throws ParseException {
		long now = System.currentTimeMillis();
		long line = getline(date, dayTime, addDay);
		Date startTime = null;
		Date endTime = null;
		Calendar ca = Calendar.getInstance();
		ca.setTimeInMillis(line);
		if(now >= line) {
			ca.add(Calendar.DATE, 1);
			startTime = new Date(line);
			endTime = ca.getTime();
		}else {
			ca.add(Calendar.DATE, -1);
			startTime = ca.getTime();
			endTime = new Date(line);
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String startTimeStr = sdf.format(startTime);
		String endTimeStr = sdf.format(endTime);
		Calendar startCa = Calendar.getInstance();
		Calendar endCa = Calendar.getInstance();
		startCa.setTime(startTime);
		endCa.setTime(endTime);
		SimpleDateFormat yMd = new SimpleDateFormat("yyyy-MM-dd");
    	String startDateStr = yMd.format(startTime);
    	Date startDate = yMd.parse(startDateStr);
    	String endDateStr = yMd.format(endTime);
    	Date endDate = yMd.parse(endDateStr);
		
		ResetDayTime vo = new ResetDayTime();
		vo.setStartDateTs(startDate.getTime());
		vo.setEndDateTs(endDate.getTime());
		vo.setStartDate(startDate);
		vo.setEndDate(endDate);
		vo.setStartCa(startCa);
		vo.setEndCa(endCa);
		vo.setStartTime(startTime);
		vo.setEndTime(endTime);
		vo.setStartTimeStr(startTimeStr);
		vo.setEndTimeStr(endTimeStr);
		return vo;
	}
	
	private static long getline(Date date, DayTimeEnum dayTime, int addDay) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		Calendar ca = Calendar.getInstance();
		ca.setTime(date);
		ca.add(Calendar.DATE, addDay);
		ca.set(Calendar.HOUR_OF_DAY, dayTime.getHour());
		ca.set(Calendar.MINUTE, dayTime.getMinute());
		ca.set(Calendar.SECOND, dayTime.getSecond());
		ca.set(Calendar.MILLISECOND, 0);
		Date time = ca.getTime();
		String format = sdf.format(time);
		Date parse2 = sdf.parse(format);
		ca.setTime(parse2);
		long line = ca.getTimeInMillis();
		return line;
	}
	
	public static <T> Over<T> getOvers2(List<T> list1, List<T> list2, boolean obj, String attr, String...subs) throws Exception{
		if(list1 == null) {
			list1 = new ArrayList<T>();
		}
		if(list2 == null) {
			list2 = new ArrayList<T>();
		}
		
		List<T> adds = new ArrayList<T>();
        List<T> dels = new ArrayList<T>();
        List<T> updates = new ArrayList<T>();
        List<T> same1 = new ArrayList<T>();
        List<T> same2 = new ArrayList<T>();
		if(obj) {
			Map<Object, T> map1 = new HashMap<Object, T>();
			for(T t : list1) {
				Object val = getVal(attr, t);
				map1.put(val, t);
			}
			Map<Object, T> map2 = new HashMap<Object, T>();
			for(T t : list2) {
				Object val = getVal(attr, t);
				map2.put(val, t);
				if(map1.get(val) == null) {
					dels.add(t);
					continue;
				}
				same2.add(t);
			}
			for(T t : list1) {
				Object val = getVal(attr, t);
				if(map2.get(val) == null) {
					adds.add(t);
					continue;
				}
				same1.add(t);
			}
			if(same2.size() > 0) {
				Map<Object, T> attr_s1 = Utils1.getMap(same1, attr);
				for(T s2 : same2) {
					T s1 = attr_s1.get(Utils1.getVal(attr, s2));
					int sign = 0;
					for(String sub : subs) {
						T val1 = Utils1.getVal(sub, s1);
						T val2 = Utils1.getVal(sub, s2);
						if(val1.equals(val2)) {
							continue;
						}
						Utils1.setVal(sub, val1, s2);
						sign = 1;
						break;
					}
					if(sign == 1) {
						updates.add(s2);
					}
				}
			}
			
		}else {
			Map<T, T> map1 = new HashMap<T, T>();
			for(T t : list1) {
				map1.put(t, t);
			}
			Map<T, T> map2 = new HashMap<T, T>();
			for(T t : list2) {
				map2.put(t, t);
				if(map1.get(t) == null) {
					dels.add(t);
					continue;
				}
				same2.add(t);
			}
			for(T t : list1) {
				if(map2.get(t) == null) {
					adds.add(t);
					continue;
				}
				same1.add(t);
			}
		}
		return new Over<T>(adds, dels, updates);
	}
	
	public static <O> Map<String, String> obj2Map(O o, boolean isSaveNull) throws Exception{
		Class<? extends Object> clazz = o.getClass();
		Field[] fields = clazz.getDeclaredFields();
		Map<String, String> map = new HashMap<String, String>();
		for(Field field : fields) {
			field.setAccessible(true);
			String key = field.getName();
			Object obj = field.get(o);
			if(obj == null) {
				if(isSaveNull) {
					map.put(key, null);
				}
				continue;
			}
			map.put(key, String.valueOf(obj));
		}
		return map;
	}
	
	public static boolean isEquals(String a, String b) {
    	if(a == null && b == null) {
    		return true;
    	}else if(a != null && b == null) {
    		return a.equals("");
    	}else if(a == null && b != null) {
    		return b.equals("");
    	}else if(a != null && b != null) {
    		return a.equals(b);
    	}
    	return false;
    }
	
	public static boolean isEquals(Number a, Number b) {
    	if(a == null && b == null) {
    		return true;
    	}else if(a != null && b == null) {
    		return false;
    	}else if(a == null && b != null) {
    		return false;
    	}else if(a != null && b != null) {
    		BigDecimal bd1 = new BigDecimal(a.toString());
    		BigDecimal bd2 = new BigDecimal(b.toString());
    		return  bd1.compareTo(bd2) == 0;
    	}
    	return false;
    }
	
	public static boolean isEquals(Number a, String b) {
    	if(a == null && StringUtils.isBlank(b)) {
    		return true;
    	}else if(a != null && StringUtils.isBlank(b)) {
    		return false;
    	}else if(a == null && StringUtils.isNotBlank(b)) {
    		return false;
    	}else if(a != null && StringUtils.isNotBlank(b)) {
    		BigDecimal bd1 = new BigDecimal(a.toString());
    		BigDecimal bd2 = new BigDecimal(b);
    		return  bd1.compareTo(bd2) == 0;
    	}
    	return false;
    }
	
	public static boolean isEquals(String a, Number b) {
    	if(StringUtils.isBlank(a) && b == null) {
    		return true;
    	}else if(StringUtils.isBlank(a) && b != null) {
    		return false;
    	}else if(StringUtils.isNotBlank(a) && b == null) {
    		return false;
    	}else if(StringUtils.isNotBlank(a) && b != null) {
    		BigDecimal bd1 = new BigDecimal(a);
    		BigDecimal bd2 = new BigDecimal(b.toString());
    		return  bd1.compareTo(bd2) == 0;
    	}
    	return false;
    }
}
