package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.alibaba.fastjson.JSON;
import com.gogo.common.constants.RegexConstant;

public class StringUtil1 {

	/**
	 * 去除html的特殊符号 如：&nbsp; &gt;等
	 * @param str
	 * @return
	 */
	public static String replaceHTML(String str) {
		String dest = "";
		if(str != null) {
			Pattern p = Pattern.compile(RegexConstant.html);
			Matcher m = p.matcher(str);
			dest = m.replaceAll("");
		}
		return dest;
	}

	/**
	 * 去除各式各样的空白串
	 * 
	 * @param str
	 * @return
	 */
	public static String trimAll(String str) {
		String dest = "";
		if (str != null) {
			// 倒数第二个空格与空格键打出来的空格不一样！
			Pattern p = Pattern.compile(RegexConstant.blank);
			Matcher m = p.matcher(str);
			dest = m.replaceAll("");
		}
		return dest;
	}

	/**
	 * 去除头尾的空白串加强
	 * 
	 * @param str
	 * @return
	 */
	public static String trim(String str) {
		return Pattern.compile("^(" + RegexConstant.blank + ")|(" + RegexConstant.blank + ")$").matcher(str)
				.replaceAll("");
	}

	/**
	 * 所有空格替换为标准空格
	 * 
	 * @param str
	 * @return
	 */
	public static String replaceNomalBlank(String str) {
		String dest = "";
		if (str != null) {
			// 倒数第二个空格与空格键打出来的空格不一样！
			Pattern p = Pattern.compile(RegexConstant.blank);
			Matcher m = p.matcher(str);
			dest = m.replaceAll(" ");
		}
		return dest;
	}

	/**
	 * 去除字符串的“-”和空串
	 * 
	 * @param str
	 * @return
	 */
	public static String replaceBlank2(String str) {
		String dest = "";
		if (str != null) {
			Pattern p = Pattern.compile("-|\\s");
			Matcher m = p.matcher(str);
			dest = m.replaceAll("");
		}
		return dest;
	}

	public static String randomString(int len) {
		String randomSource = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < len; i++) {
			int number = new Random().nextInt(62);
			sb.append(randomSource.charAt(number));
		}
		return sb.toString();
	}

	public static String StringLimit(String str, int limit) {
		int strLen = str.length();

		double count = 0.0d;
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < strLen; i++) {
			int asciicode = str.codePointAt(i);
			if (asciicode > 255) {
				count = count + 1.0d;
			} else {
				count = count + 0.5d;
			}
			if (count > limit) {
				sb.append("...");
				break;
			}
			sb.append(str.charAt(i));
		}
		return sb.toString();
	}
	
	public static Boolean isHttp(String str) {
		if(str.startsWith("http://") || str.startsWith("https://")) {
			return true;
		}
		return false;
	}
	
	public static String beUrl(String host, String uri) {
		boolean hostEnd = false;
		if(host.endsWith("/") || host.endsWith("\\")) {
			hostEnd = true;
		}
		boolean uriStart = false;
		if(uri.startsWith("/") || uri.startsWith("\\")) {
			uriStart = true;
		}
		
		if(hostEnd && uriStart) {
			return host+uri.substring(1);
		}else if(!hostEnd && !uriStart) {
			return host+"/"+uri;
		}else {
			return host + uri;
		}
	}
	
	/**
     * 将字符串text中由openToken和closeToken组成的占位符依次替换为args数组中的值
     * @param openToken
     * @param closeToken
     * @param text
     * @param args
     * @return
     */
    public static String parse(String openToken, String closeToken, String text, Object... args) {
        if (args == null || args.length <= 0) {
            return text;
        }
        int argsIndex = 0;

        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        // search open token
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        final StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                // this open token is escaped. remove the backslash and continue.
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                // found open token. let's search close token.
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        // this close token is escaped. remove the backslash and continue.
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                    } else {
                        expression.append(src, offset, end - offset);
                        offset = end + closeToken.length();
                        break;
                    }
                }
                if (end == -1) {
                    // close token was not found.
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    ///////////////////////////////////////仅仅修改了该else分支下的个别行代码////////////////////////

                    String value = (argsIndex <= args.length - 1) ?
                            (args[argsIndex] == null ? "" : args[argsIndex].toString()) : expression.toString();
                    builder.append(value);
                    offset = end + closeToken.length();
                    argsIndex++;
                    ////////////////////////////////////////////////////////////////////////////////////////////////
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String parse(String text, Object... args) {
        return StringUtil1.parse("${", "}", text, args);
    }
    
    public static String parse(String text, Map<String, String> args) {
    	for(String key : args.keySet()) {
    		text = text.replaceAll("\\$\\{"+key+"\\}", String.valueOf(args.get(key)));
    	}
    	return text;
    }
    
    public static Map<String, Object> xmlStr2Map(String xmlStr) throws Exception {
    	ByteArrayInputStream in = null;
    	try {
    		SAXReader reader = new SAXReader();
    		in = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
    		Document doc = reader.read(in);
    		if(doc == null) {
    			return null;
    		}
    		return doc2Map(doc);
		} finally {
			if(in != null) {
				in.close();
			}
		}
    }
    
    public static Map<String, Object> doc2Map(Document doc){
    	 Map<String, Object> map = new HashMap<String, Object>();  
         Element root = doc.getRootElement();  
         for (Iterator<Element> iterator = root.elementIterator(); iterator.hasNext();) {
             Element e = iterator.next();
             List<Element> list = e.elements();
             if(list.size() > 0){  
                 map.put(e.getName(), elements2Map(list));
             }else {
             	map.put(e.getName(), e.getText());
             }
         }  
         if(map.size() > 0) {
     		return map;
     	}
     	return null;
    }
    
    public static Map<String, Object> element2Map(Element e){
    	Map<String, Object> map = new HashMap<String, Object>();
    	String name = e.getName();
    	Object val = null;
    	List<Element> elements = e.elements();
    	if(elements.isEmpty()) {
    		val = e.getTextTrim();
    	}else {
    		val = elements2Map(elements);
    	}
    	map.put(name, val);
    	if(map.size() > 0) {
    		return map;
    	}
    	return null;
    }
    
    public static Map<String, Object> elements2Map(List<Element> es) {
    	Map<String, Object> map = new HashMap<String, Object>();
    	for(Element e : es) {
    		Map<String, Object> element2Map = element2Map(e);
    		map.putAll(element2Map);
    	}
    	if(map.size() > 0) {
    		return map;
    	}
    	return null;
    }
    
    public static String map2XmlStr(Map<String, Object> map) {
    	String rootName = "xml";
    	return map2XmlStr(rootName, map);
    }
    
	public static String map2XmlStr(String rootName, Map<String, Object> map) {
    	if(StringUtils.isBlank(rootName)) {
    		throw new IllegalArgumentException("root节点不能为空！");
    	}
    	StringBuilder sb = new StringBuilder();
		sb.append("<").append(rootName).append(">");
    	sb.append(innerMap2XmlStr(map));
		sb.append("</").append(rootName).append(">");
    	return sb.toString();
    }
    
	@SuppressWarnings({ "rawtypes", "unchecked" })
    private static String innerMap2XmlStr(Map<String, Object> map) {
    	StringBuilder sb = new StringBuilder();
    	for(String key : map.keySet()) {
    		sb.append("<").append(key).append(">");
    		Object val = map.get(key);
    		if(val instanceof Map) {
    			String inner = innerMap2XmlStr((Map) val);
    			sb.append(inner);
    		}else {
    			sb.append(String.valueOf(val));
    		}
    		sb.append("</").append(key).append(">");
    	}
    	return sb.toString();
    }
	
	public static String params2Json(String strs) {
		if(StringUtils.isBlank(strs)) {
			return "";
		}
		strs = strs.replaceAll("^\\?", "");
		String[] strArr = strs.split("&");
		StringBuilder json = new StringBuilder("{");
		for(String str : strArr) {
			String[] sigleArr = str.split("=");
			json.append("\"").append(sigleArr[0]).append("\"");
			json.append(":");
			json.append("\"").append(sigleArr[1]).append("\"");
			json.append(",");
		}
		return json.replace(json.length()-1, json.length(), "}").toString();
	}
	
	public static Map<String, String> params2Map(String strs){
		Map<String, String> map = new HashMap<String, String>();
		if(StringUtils.isBlank(strs)) {
			return map;
		}
		strs = strs.replaceAll("\\?", "");
		String[] strArr = strs.split("&");
		for(String str : strArr) {
			String[] sigleArr = str.split("=");
			map.put(sigleArr[0], sigleArr[1]);
		}
		return map;
	}
	
	public static String map2Params(Map<String, String> map) {
		if(map == null || map.size() == 0) {
			return "";
		}
		StringBuilder sb = new StringBuilder("?");
		for(String key : map.keySet()) {
			sb.append(key).append("=").append(map.get(key)).append("&");
		}
		return sb.substring(0, sb.length()-1);
	}
	
	public static <O> String Obj2Params(O o) throws Exception {
		Class<? extends Object> clazz = o.getClass();
		Field[] fields = clazz.getDeclaredFields();
		StringBuilder sb = new StringBuilder("?");
		for(Field field : fields) {
			field.setAccessible(true);
			String key = field.getName();
			Object obj = field.get(o);
			if(obj == null) {
				continue;
			}
			if(Utils1.isMinimumType(obj)) {
				sb.append(key).append("=").append(String.valueOf(obj)).append("&");
			}
		}
		return sb.substring(0, sb.length()-1);
	}
	
	public static String xmlStr2Json(String xmlStr) throws Exception {
		Map<String, Object> doc2Map = xmlStr2Map(xmlStr);
		return JSON.toJSONString(doc2Map);
    }
	
	public static String getXmlStr(HttpServletRequest request) throws IOException {
		InputStream inStream = null;
		ByteArrayOutputStream outSteam = null;
		try {
			inStream = request.getInputStream();
			outSteam = new ByteArrayOutputStream();
			byte[] buffer = new byte[1024];
	        int len = 0;
	        while ((len = inStream.read(buffer)) != -1) {
	            outSteam.write(buffer, 0, len);
	        }
	        String resultxml = new String(outSteam.toByteArray(), "utf-8");
	        return resultxml;
		} finally {
			if(outSteam != null) {
				outSteam.close();
			}
			if(inStream != null) {
				inStream.close();
			}
		}
	}
	
	public static String bePath(String... strs) {
		if(strs == null || strs.length == 0) {
			return null;
		}
		StringBuilder path = new StringBuilder();
		for(int i=0; i<strs.length; i++) {
			String str = strs[i];
			str = str.replaceAll("(/|\\\\)$", "").replaceAll("^(\\\\)", "/");
			if(i == 0) {
				path.append(str);
				continue;
			}
			if(!str.startsWith("/") && !str.startsWith("\\")) {
				path.append("/").append(str);
				continue;
			}
			path.append(str);
		}
		return path.toString();
	}
	
	//英语句子：每个单词间隔一个空格，前后没有空格，每个单词首字母大写
	public static String standardFirstToUpperEachWord(String sentence) {
		if(StringUtils.isBlank(sentence)) {
			return sentence;
		}
		String[] split = sentence.split(" ");
		StringBuffer sb = new StringBuffer();
		for(String s : split) {
			if(StringUtils.isBlank(s)) {
				continue;
			}
			String lowerCase = s.toLowerCase();
			Matcher m = Pattern.compile("^(.){1}").matcher(lowerCase);
			StringBuffer sbz = new StringBuffer();
			if (m.find()) {
				m.appendReplacement(sbz, m.group().toUpperCase());
			}
			m.appendTail(sbz);
			sb.append(sbz).append(" ");
		}
		return sb.toString().trim();
	}
	
	//英语句子：每个单词间隔一个空格，前后没有空格，所有单词首字母大写
	public static String standardAllToUpper(String sentence) {
		if(StringUtils.isBlank(sentence)) {
			return sentence;
		}
		String[] split = sentence.split(" ");
		StringBuffer sb = new StringBuffer();
		for(String s : split) {
			if(StringUtils.isBlank(s)) {
				continue;
			}
			String lowerCase = s.toUpperCase();
			sb.append(lowerCase).append(" ");
		}
		return sb.toString().trim();
	}
	
	//英语句子：每个单词间隔一个空格，前后没有空格
	public static String standardOnly(String sentence) {
		if(StringUtils.isBlank(sentence)) {
			return sentence;
		}
		String[] split = sentence.split(" ");
		StringBuffer sb = new StringBuffer();
		for(String s : split) {
			if(StringUtils.isBlank(s)) {
				continue;
			}
			sb.append(s).append(" ");
		}
		return sb.toString().trim();
	}
}
