package oth.syk.common.tools;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

import com.itextpdf.text.Document;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;

public class PDFUtil1 {
	
	public static byte[] mergePdf(List<String> files) throws Exception {
		ByteArrayOutputStream baos = null;
		try {
			baos = new ByteArrayOutputStream();
			Document document = null;
			PdfCopy copy = null;
			try {
				document = new Document(PageSize.A4);
				copy = new PdfCopy(document, baos);
	            document.open();
				for (int i = 0; i < files.size(); i++) {
					PdfReader reader = null;
					try {
						reader = new PdfReader(files.get(i));
		                int n = reader.getNumberOfPages();
		                for (int j = 1; j <= n; j++) {
		                    document.newPage();
		                    PdfImportedPage page = copy.getImportedPage(reader, j);
		                    copy.addPage(page);
		                }
					} finally {
						if(reader != null) {
							reader.close();
						}
					}
		        }
			} finally {
				if(document != null) {
					document.close();
				}
				if(copy != null) {
					copy.close();
				}
			}
			return baos.toByteArray();
		} finally {
			if(baos != null) {
				baos.close();
			}
		}
    }
}
