package oth.syk.common.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import com.gogo.common.tools.ConfigUtils;
import com.gogo.common.tools.DateUtil;
import com.gogo.common.tools.FileUtils;
import com.gogo.common.ui.GCS.GCSFileInfo;
import com.google.api.gax.paging.Page;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Blob.BlobSourceOption;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.collect.Lists;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

public class GCSUtils1 {
	private static String secretPath="/google_secret.json";
	
	static {
		String proxySet = ConfigUtils1.getPropertyValue("proxy.set");
		String proxyType = ConfigUtils1.getPropertyValue("proxy.type");
		String proxyPort = ConfigUtils1.getPropertyValue("proxy.port");
		String proxyHost = ConfigUtils1.getPropertyValue("proxy.host");
		
		if(StringUtils.isNotBlank(proxySet)) {
			System.setProperty("proxyType", proxyType); // 设置代理类型，4应该是指http
			System.setProperty("proxyPort", proxyPort); // 设置代理的端口号
			System.setProperty("proxyHost", proxyHost); // 设置代理的ip地址
			System.setProperty("proxySet", proxySet); // 使代理生效
		}
	}
	
	public static void upload(String bucketName, String storedFilePath, byte[] bytes) throws IOException {
		BlobId blobId = BlobId.of(bucketName, storedFilePath);
	    BlobInfo blobInfo = BlobInfo.newBuilder(blobId).build();
	    getStorage().create(blobInfo, bytes);
	}
	
	public static List<GCSFileInfo> list(String bucketName, String prefix) throws IOException, ParseException {
		Storage storage = getStorage();
		Page<Blob> list = storage.list(bucketName,Storage.BlobListOption.prefix("nod_nts/"),
	            Storage.BlobListOption.currentDirectory());
		List<GCSFileInfo> sources = new ArrayList<GCSFileInfo>();
		for(Blob b : list.iterateAll()) {
			String objectName = b.getName().substring(b.getName().lastIndexOf("/")+1);
			GCSFileInfo build = GCSFileInfo.builder().name(b.getName()).createTime(DateUtil1.str2Date(b.getCreateTime()+"")).objectName(objectName).mTime(DateUtil1.str2Date(b.getUpdateTime()+"")).build();
			sources.add(build);
		}
		return sources;
	}
	
	public static byte[] download(String bucketName, String source) throws IOException {
		ByteArrayOutputStream os = null;
		try {
			Blob blob = getStorage().get(BlobId.of(bucketName, source));
		    os = new ByteArrayOutputStream();
		    blob.downloadTo(os);
		} finally {
			if(os != null) {
				os.close();
			}
		}
		return os.toByteArray();
	}
	
	private static Storage getStorage() throws IOException {
		InputStream is = null;
		try {
			is = GCSUtils1.class.getResourceAsStream(secretPath);
			GoogleCredentials credentials = GoogleCredentials.fromStream(is).createScoped(Lists.newArrayList("https://www.googleapis.com/auth/cloud-platform"));
			return StorageOptions.newBuilder().setCredentials(credentials).build().getService();
		} finally {
			if(is != null) {
				is.close();
			}
		}
	}
}
