package oth.syk.common.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.system.ApplicationHome;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FileUtils1 {
	
	public static void saveFile(File file, String targetPathStr, String fileName, String suffix) throws IOException {
		try (InputStream input = new FileInputStream(file);) {
    		saveFile(IOUtils.toByteArray(input), targetPathStr, fileName, suffix);
		}
    }
	
	public static void saveFile(byte[] content, String targetDir, String fileName, String suffix) throws IOException{
		File file = new File(targetDir);
		if(!file.exists()) {
			file.mkdirs();
		}
		//创建一个文件输出流
		try (FileOutputStream output = new FileOutputStream(targetDir + "/" + fileName + "."+suffix);) {
			IOUtils.write(content, output);
		}
	}
	
	public static void saveFile(byte[] content, String targetFile) throws IOException{
		String dir = targetFile.substring(targetFile.lastIndexOf("/")+1);
		File file = new File(dir);
		if(!file.exists()) {
			file.mkdirs();
		}
		//创建一个文件输出流
		try (FileOutputStream output = new FileOutputStream(targetFile)) {
			IOUtils.write(content, output);
		}
	}
	
	public static byte[] getBytes(String path) throws Exception {
		File file = new File(path);
		return getBytes(file);
	}
	
	public static byte[] getBytes(File file) throws Exception {
		InputStream is = null;
		try {
			if(!file.exists()) {
				throw new IOException("The file: "+file.getPath() +" is not exists!");
			}
			is = new FileInputStream(file);
			return IOUtils.toByteArray(is);
		} finally {
			if(is != null) {
				is.close();
				is = null;
			}
		}
	}
	
	public static Set<String> txt2Set(InputStream txtStream) throws Exception{
		InputStreamReader isr = null;
		BufferedReader br = null;
		try {
			isr = new InputStreamReader(txtStream, "utf-8");
			br = new BufferedReader(isr);
			
			String lineTxt = null;
			Set<String> set = new HashSet<>();
			while ((lineTxt = br.readLine()) != null) {
				set.add(lineTxt);
		    }
			return set;
		} finally {
			if(br != null) {
				br.close();
			}
			
			if(isr != null) {
				isr.close();
			}
		}
	}
	
	public static String getDir() {
		String dateStr = DateUtil1.date2Str(new Date(), "yyyyMM");
		StringBuilder sb = new StringBuilder();
		sb.append("/").append(dateStr);
		return sb.toString();
	}
	
	public static String getJarHome() {
		ApplicationHome h = new ApplicationHome(FileUtils1.class);
        File jarF = h.getSource();
        if(jarF == null) {
        	log.info("This app is not a jar!");
        	return null;
        }
        return jarF.getParentFile().toString();
	}
	
	public static String getFileCharset(String path) throws IOException {
		String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            boolean checked = false;
            File file = new File(path);
            is = new FileInputStream(file);
            bis = new BufferedInputStream(is);
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset; //文件编码为 ANSI
            } else if (first3Bytes[0] == (byte) 0xFF
                    && first3Bytes[1] == (byte) 0xFE) {
                charset = "UTF-16LE"; //文件编码为 Unicode
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xFE
                    && first3Bytes[1] == (byte) 0xFF) {
                charset = "UTF-16BE"; //文件编码为 Unicode big endian
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xEF
                    && first3Bytes[1] == (byte) 0xBB
                    && first3Bytes[2] == (byte) 0xBF) {
                charset = "UTF-8"; //文件编码为 UTF-8
                checked = true;
            }
            bis.reset();
            if (!checked) {
                while ((read = bis.read()) != -1) {
                    if (read >= 0xF0)
                        break;
                    if (0x80 <= read && read <= 0xBF) // 单独出现BF以下的，也算是GBK
                        break;
                    if (0xC0 <= read && read <= 0xDF) {
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) // 双字节 (0xC0 - 0xDF)
                            // (0x80
                            // - 0xBF),也可能在GB编码内
                            continue;
                        else
                            break;
                    } else if (0xE0 <= read && read <= 0xEF) {// 也有可能出错，但是几率较小
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) {
                            read = bis.read();
                            if (0x80 <= read && read <= 0xBF) {
                                charset = "UTF-8";
                                break;
                            } else
                                break;
                        } else
                            break;
                    }
                }
            }
        } finally {
			if(bis != null) {
				bis.close();
			}
			if(is != null) {
				is.close();
			}
		}
        return charset;
	}
	
	public static boolean delete(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        } else {
            if (file.isFile()) {
                return deleteFile(fileName);
            } else {
                return deleteDirectory(fileName);
            }
        }
    }
	
	public static Map<String, String> getMapFromTxt(String txtPath, String separator) throws IOException {
		Map<String, String> map = new HashMap<String, String>();
		try (
			FileInputStream fis = new FileInputStream(txtPath);
			InputStreamReader isr = new InputStreamReader(fis);
			BufferedReader br = new BufferedReader(isr);
		){
			String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {
                String[] split = lineTxt.split("=");
                if(StringUtils.isBlank(split[0])) {
                	continue;
                }
    			map.put(split[0], split[1]);
            }
		}
		
		return map;
	}
	
	public static Map<String, Set<String>> getMapGroupFromTxt(String txtPath, String separator) throws IOException {
		Map<String, Set<String>> map = new HashMap<String, Set<String>>();
		try (
			FileInputStream fis = new FileInputStream(txtPath);
			InputStreamReader isr = new InputStreamReader(fis);
			BufferedReader br = new BufferedReader(isr);
		){
			String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {
                String[] split = lineTxt.split("=");
                if(StringUtils.isBlank(split[0])) {
                	continue;
                }
                Set<String> set = map.get(split[0]);
                if(set == null) {
                	set = new HashSet<String>();
                	map.put(split[0], set);
                }
                set.add(split[1]);
            }
		}
		
		return map;
	}
 
    /**
     * 删除单个文件
     *
     * @param fileName：要删除的文件的文件名
     * @return 单个文件删除成功返回true，否则返回false
     */
    private static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        // 如果文件路径所对应的文件存在，并且是一个文件，则直接删除
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
	
	private static boolean deleteDirectory(String dir) {
        // 如果dir不以文件分隔符结尾，自动添加文件分隔符
        if (!dir.endsWith(File.separator))
            dir = dir + File.separator;
        File dirFile = new File(dir);
        // 如果dir对应的文件不存在，或者不是一个目录，则退出
        if ((!dirFile.exists()) || (!dirFile.isDirectory())) {
            return false;
        }
        boolean flag = true;
        // 删除文件夹中的所有文件包括子目录
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; i++) {
            // 删除子文件
            if (files[i].isFile()) {
                flag = deleteFile(files[i].getAbsolutePath());
                if (!flag)
                    break;
            }
            // 删除子目录
            else if (files[i].isDirectory()) {
                flag = deleteDirectory(files[i].getAbsolutePath());
                if (!flag)
                    break;
            }
        }
        if (!flag) {
            return false;
        }
        // 删除当前目录
        if (dirFile.delete()) {
            return true;
        } else {
            return false;
        }
    }
}
