package oth.syk.common.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;

/**
 * 对easypoi 一些简单的封装操作类 
 * 官方文档：http://easypoi.mydoc.io/
 * @author lhp
 *
 */
public class ExcelUtil1 {
	/**
	 * 导出Excel(如果fileName为空则会生成一个流水号命名,文件格式为.xlsx)
	 * @param list 导出的集合数据
	 * @param title Excel标题名称
	 * @param sheetName excel页的名称
	 * @param pojoClass 对应的实体类Class
	 * @param fileName 文件名称
	 * @param response HTTP输出流
	 * @throws IOException 
	 */
	public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass,String fileName, HttpServletResponse response) throws IOException{
        if(response == null){
        	throw new IllegalArgumentException("输出流对象不能为空。");
        }
        if(pojoClass == null){
        	throw new IllegalArgumentException("导出Excel的实体对象类不能为空。");
        }
        if(list == null){
        	list = new ArrayList<>();
        }
		if(StringUtils.isBlank(fileName)){
        	fileName = UIDGen1.getUID()+ ".xlsx";
        }else{
        	fileName+=".xlsx";
        }
		defaultExport(list, pojoClass, fileName, response, new ExportParams(title, sheetName));
    }
	/**
	 * 生成Excel
	 * @param list 集合数据
	 * @param pojoClass 对应的实体类Class
	 * @param fileName 文件名称
	 * @param response HTTP输出流
	 * @param exportParams 导出配置的参数
	 * @throws IOException 
	 */
	private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, ExportParams exportParams) throws IOException {
		if(response == null){
        	throw new IllegalArgumentException("输出流对象不能为空。");
        }
        if(pojoClass == null){
        	throw new IllegalArgumentException("导出Excel的实体对象类不能为空。");
        }
		Workbook workbook = ExcelExportUtil.exportExcel(exportParams,pojoClass,list);
        if (workbook != null);
        downLoadExcel(fileName, response, workbook);
    }
	/**
	 * 通过Response流下载Excel文件
	 * @param fileName 文件名称
	 * @param response 请求流
	 * @param workbook Excel对象
	 * @throws IOException 
	 */
	private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) throws IOException {
		if(StringUtils.isBlank(fileName)){
			throw new IllegalArgumentException("文件名称不能为空。");
		}
		if(response == null){
        	throw new IllegalArgumentException("输出流对象不能为空。");
        }
        if(workbook == null){
        	throw new IllegalArgumentException("Excel对象不能为空。");
        }
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition",
                "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        workbook.write(response.getOutputStream());
    }
	
	public static void fillTemplate2Live(String templatePath, String liveDir, String fileName, Map<String, Object> dataMap) throws IOException{
    	if(StringUtils.isBlank(templatePath)) {
    		throw new IllegalArgumentException("模板路径不能为空！");
    	}
    	if(StringUtils.isBlank(liveDir)) {
    		throw new IllegalArgumentException("生成路径不能为空！");
    	}
    	OutputStream os = null;
    	try {
    		TemplateExportParams params = new TemplateExportParams(templatePath,true);
    		Workbook workbook = ExcelExportUtil.exportExcel(params , dataMap);
    		File dir = new File(liveDir);
    		if(!dir.exists()) {
    			dir.mkdirs();
    		}
    		File file = new File(StringUtil1.bePath(liveDir, fileName));
    		os = new FileOutputStream(file);
    		workbook.write(os);
		} finally {
			if(os != null) {
				os.close();
			}
		}
    }
}
