package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.linuxense.javadbf.DBFReader;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class DbfUtils1 {
	
	private static final String charset = "utf-8";
	
	public static List<Map<String, String>> readDbf(byte[] bytes) throws Exception {  
		if(bytes == null || bytes.length == 0) {
			return null;
		}
		List<Map<String, String>> rowList = new ArrayList<>();
		InputStream is = null;
		DBFReader dbfReader = null;
		try {
			is = new ByteArrayInputStream(bytes);
			dbfReader = new DBFReader(is, Charset.forName(charset));
			Object[] rowValues;
			while ((rowValues = dbfReader.nextRecord()) != null) {
				Map<String, String> map = new HashMap<String, String>();
				for (int i = 0; i < rowValues.length; i++) {
					String key = dbfReader.getField(i).getName();
					String val = String.valueOf(rowValues[i]);
					if(StringUtils.isBlank(val) || val.equals("null")) {
						continue;
					}
					map.put(key, val);
				}
				rowList.add(map);
			}
		}finally {
			if(dbfReader != null) {
				dbfReader.close();
			}
			if(is != null) {
				is.close();
			}
		}
		
		return rowList;
	}
}
