package oth.syk.common.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.poi.ss.formula.functions.T;

import com.gogo.common.tools.Utils;

import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvUtil;

public class CvsUtils1 {

	public static <T> List<T> redCvs(byte[] bytes, Class<T> cls) throws Exception{
		List<T> ts = new ArrayList<T>();
		ByteArrayInputStream bais = null;
		InputStreamReader isr = null;
		try {
			bais = new ByteArrayInputStream(bytes);
			isr = new InputStreamReader(bais);
			CsvReader csvReader = CsvUtil.getReader();
			CsvData data = csvReader.read(isr);
			CsvRow headRow = data.getRow(0);
			for(int i=1; i<data.getRowCount(); i++) {
				CsvRow row = data.getRow(i);
				T t = cls.newInstance();
				for(int j=0; j<headRow.getFieldCount(); j++) {
					String key = headRow.get(j);
					if(key.indexOf("_") == -1 && isAllUpper(key)) {
						key = key.toLowerCase();
					}else {
						key = humpUtils1.toLowerCaseFirstOne(key);
					}
					String val = row.get(j);
					Utils1.setValToned(key, val, t);
				}
				ts.add(t);
			}
		} finally {
			if(isr != null) {
				isr.close();
			}
			if(bais != null) {
				bais.close();
			}
		}
		
		return ts;
	}
	
	private static boolean isAllUpper(String key) {
		for(int i = 0; i < key.length(); i++) {
			char c = key.charAt(i);
			if (Character.isLowerCase(c)) {
				return false;
			}
		}
		return true;
	}
}
