package oth.syk.common.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import com.gogo.common.ui.Cron.*;

public class CronUtil1 {
	private static final String once = "ss mm HH dd MM ? yyyy-yyyy";
	private static final String yearly = "ss mm HH dd MM ? *";
	private static final String monthly = "ss mm HH dd * ?";
	private static final String daily = "ss mm HH * * ?";
	private static final String hourly = "ss mm * * * ?";
	private static final String minutely = "ss * * * * ?";
	private static final String secondly = "* * * * * ?";
	private static final String weekly = "ss mm HH ? * E";
	
	public static String once(Year year, Month month, Day day, Hour hour, Minute minute, Second second) {
		if(year == null || month == null || day == null || 
				hour == null || minute == null || second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(year, month, day, hour, minute, second, null, once);
	}
	
	public static String once(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(once, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	public static String yearly(Month month, Day day, Hour hour, Minute minute, Second second) {
		if(month == null || day == null || hour == null || minute == null || second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, month, day, hour, minute, second, null, yearly);
	}
	
	public static String yearly(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(yearly, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	public static String monthly(Day day, Hour hour, Minute minute, Second second) {
		if(day == null || hour == null || minute == null || second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, null, day, hour, minute, second, null, monthly);
	}
	
	public static String monthly(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(monthly, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	public static String daily(Hour hour, Minute minute, Second second) {
		if(hour == null || minute == null || second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, null, null, hour, minute, second, null, daily);
	}
	
	public static String daily(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(daily, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	public static String hourly(Minute minute, Second second) {
		if(minute == null || second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, null, null, null, minute, second, null, hourly);
	}
	
	public static String hourly(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(hourly, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	public static String minutely(Second second) {
		if(second == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, null, null, null, null, second, null, minutely);
	}
	
	public static String minutely(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(minutely, new Locale("en", "CN"));
		return sdf.format(date);
	}

	public static String secondly() {
		return secondly;
	}
	
	public static String weekly(Hour hour, Minute minute, Second second, Week week) {
		if(hour == null || minute == null || second == null || week == null) {
			throw new RuntimeException("参数不能为空！");
		}
		return tt(null, null, null, hour, minute, second, week, weekly);
	}
	
	public static String weekly(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(weekly, new Locale("en", "CN"));
		return sdf.format(date);
	}
	
	private static String tt(Year year, Month month, Day day, Hour hour, Minute minute, Second second, Week week, String cronExp) {
		String yearStr = "";
    	if(year != null) {
    		int[] years = year.getVals();
    		Integer startYear = years[0];
    		Integer endYear = years[years.length-1];
    		yearStr = startYear + "-" + endYear;
    	}
    	String monthStr = "";
    	if(month != null) {
    		monthStr = ArrayUtil1.join(month.getVals(), ",");
    	}
    	
    	String dayStr = "";
    	if(day != null) {
    		dayStr = ArrayUtil1.join(day.getVals(), ",");
    	}
    	String hourStr = "";
    	if(hour != null) {
    		hourStr = ArrayUtil1.join(hour.getVals(), ",");
    	}
    	String minuteStr = "";
    	if(minute != null) {
    		minuteStr = ArrayUtil1.join(minute.getVals(), ",");
    	}
    	String secondStr = "";
    	if(second != null) {
    		secondStr = ArrayUtil1.join(second.getVals(), ",");
    	}
    	String weekStr = "";
    	if(week != null) {
    		weekStr = ArrayUtil1.join(week.getVals(), ",");
    	}
    	return cronExp.replace("ss", secondStr).replace("mm", minuteStr).replace("HH", hourStr).replace("dd", dayStr).replace("MM", monthStr).replace("yyyy-yyyy", yearStr).replace("E", weekStr);
	}
}
