package oth.syk.common.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class Base64Util1 {
	
	public static String encode(String filePath) throws IOException {
		File file = new File(filePath);
		return encode(file);
	}
	
	public static String encode(File file) throws IOException {
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(file);
			return encode(fis);
		} finally {
			if(fis != null) {
				fis.close();
			}
		}
	}
	
	public static String encode(InputStream in) throws IOException {
		byte[] byteArray = IOUtils.toByteArray(in);
		return encode(byteArray);
	}
	
	public static String encode(byte[] data) {
		Base64 base64 = new Base64();
		return base64.encodeToString(data);
	}
	
	public static byte[] decode(String str) {
		Base64 base64 = new Base64();
		return base64.decode(str);
	}
}
