package oth.syk.common.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.aspose.cells.Cell;
import com.aspose.cells.Cells;
import com.aspose.cells.ImageFormat;
import com.aspose.cells.ImageOrPrintOptions;
import com.aspose.cells.License;
import com.aspose.cells.PdfCompressionCore;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.Range;
import com.aspose.cells.SheetRender;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;

import lombok.extern.slf4j.Slf4j;

/**
 * aspose for pdf
 * 
 * 
 * 最新完美破解版，无水印无文件大小限制，无使用时间限制<br>
 * 由于aspose比较吃内存，操作大一点的文件就会堆溢出，所以请先设置好java虚拟机参数：-Xms1024m -Xmx1024m(参考值)<br>
 * 本人亲自破解，内含Eclipse工程，直接导入Eclipse就能运行该demo<br>
 * 
 * ======警告：请勿用于商业用途，仅供学习研究使用，如有任何版权纠纷，本人概不负责！=====<br>
 * 
 * @author Aspose
 *
 */
@Slf4j
public class AsposeCellsUtil1 {
	
	private static InputStream license;

	/**
	 * 获取license
	 * 
	 * @return
	 */
//	private static boolean getLicense() {
//		boolean result = false;
//		try {
//			license = ConfigUtils.class.getResourceAsStream("/license.xml");
//			License aposeLic = new License();
//			aposeLic.setLicense(license);
//			result = true;
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return result;
//	}
	
	static {
		license = ConfigUtils1.class.getResourceAsStream("/license.xml");
		License aposeLic = new License();
		aposeLic.setLicense(license);
	}
	
	public static void insertVal(String source, String dest, Map<String, Object> dataMap) throws Exception {
		Workbook wb = new Workbook(source);
		Worksheet sheet = wb.getWorksheets().get(0);
		Cells cells = sheet.getCells();
		for(String coordinate : dataMap.keySet()) {
			Cell cell = cells.get(coordinate);
			cell.setValue(dataMap.get(coordinate));
		}
		wb.save(dest);
	}
	
	public static void insertPic(String source, String dest, Map<String, byte[]> dataMap) throws Exception {
		Workbook wb = new Workbook(source);
		Worksheet sheet = wb.getWorksheets().get(0);
		Cells cells = sheet.getCells();
		for(String coordinate : dataMap.keySet()) {
			Pattern p = Pattern.compile("([A-Za-z]+)(\\d+)");
			Matcher matcher = p.matcher(coordinate);
			if(!matcher.find()) {
				continue;
			}
			String col = matcher.group(1);
			int row = Integer.valueOf(matcher.group(2)) - 1;
			int colDec = excelCol2Dec(col) - 1;
			
			Cell cell = cells.get(row, colDec);
			int startRow = row;
			int startCol = colDec;
			int endRow = row + 1;
			int endCol = colDec + 1;
			if(cell.isMerged()) {
				Range mergedRange = cell.getMergedRange();
				String address = mergedRange.getAddress();
				String[] split = address.split(":");
				Matcher matcher2 = p.matcher(split[1]);
				if(matcher2.find()) {
					endRow = Integer.valueOf(matcher2.group(2));
					endCol = excelCol2Dec(matcher2.group(1));
				}
			}
			
			byte[] bytes = dataMap.get(coordinate);
			InputStream stream = new ByteArrayInputStream(bytes);
			sheet.getPictures().add(startRow, startCol, endRow, endCol, stream);
		}
		wb.save(dest);
	}
	
	public static int excelCol2Dec(String col) {
		if (col == null)
			return -1;
		char[] chrs = col.toUpperCase().toCharArray(); // 转为大写字母组成的 char数组
		int length = chrs.length;
		int ret = 0;
		for (int i = 0; i < length; i++) {
			ret += (chrs[i] - 'A' + 1) * Math.pow(26, length - i - 1); // 当做26进制来算 AAA=111 26^2+26^1+26^0
		}
		return ret;
	}
	
	public static void excel2Bmp(String excelPath, String picDir, String picName, Integer picWidth, Integer picHeight) throws Exception {
		// 验证License
//		if (!getLicense()) {
//			throw new BusinessException("license无效");
//		}
		Workbook wb = new Workbook(excelPath);
		
		Worksheet sheet = wb.getWorksheets().get(0);
        sheet.getPageSetup().setLeftMargin(-20);
        sheet.getPageSetup().setRightMargin(0);
        sheet.getPageSetup().setBottomMargin(0);
        sheet.getPageSetup().setTopMargin(0);
		
		ImageOrPrintOptions imgOptions = new ImageOrPrintOptions();
		// Specify the image format
        imgOptions.setImageFormat(ImageFormat.getBmp());
        imgOptions.setCellAutoFit(true);
        imgOptions.setOnePagePerSheet(true);
        imgOptions.setDesiredSize(picWidth,picHeight);
		// Render the sheet with respect to specified image/print options
        SheetRender render = new SheetRender(sheet, imgOptions);

		// Render the image for the sheet
        File dir = new File(picDir);
		if(!dir.exists()) {
			dir.mkdirs();
		}
        render.toImage(0, StringUtil1.bePath(picDir, picName));

	}
	
	/**
     * excel 转为pdf 输出。
     *
     * @param sourceFilePath  excel文件
     * @param desFilePathd  pad 输出文件目录
	 * @throws Exception 
     */
    public static void excel2pdf(String sourceFilePath, String desFilePathd) throws Exception{
    	// 验证License
//		if (!getLicense()) {
//			throw new BusinessException("license无效");
//		}
        Workbook wb = new Workbook(sourceFilePath);// 原始excel路径
        FileOutputStream fileOS = null;
        try {
        	fileOS = new FileOutputStream(desFilePathd);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
            pdfSaveOptions.setOnePagePerSheet(false);
            pdfSaveOptions.setPdfCompression(PdfCompressionCore.FLATE);
            //当excel中对应的sheet页宽度太大时，在PDF中会拆断并分页。此处等比缩放。
            int[] autoDrawSheets={0};
            autoDraw(wb,autoDrawSheets);
            int[] showSheets={0};
            //隐藏workbook中不需要的sheet页。
            printSheetPage(wb,showSheets);
            wb.save(fileOS, pdfSaveOptions);
            fileOS.flush();
		} finally {
			if(fileOS != null) {
				fileOS.close();
			}
		}
    }

    /**
     * 设置打印的sheet 自动拉伸比例
     * @param wb
     * @param page 自动拉伸的页的sheet数组
     */
    public static void autoDraw(Workbook wb,int[] page){
        if(null!=page&&page.length>0){
            for (int i = 0; i < page.length; i++) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }


    /**
     * 隐藏workbook中不需要的sheet页。
     * @param wb
     * @param page 显示页的sheet数组
     */
    public static void printSheetPage(Workbook wb,int[] page){
        for (int i= 1; i < wb.getWorksheets().getCount(); i++)  {
            wb.getWorksheets().get(i).setVisible(false);
        }
        if(null==page||page.length==0){
            wb.getWorksheets().get(0).setVisible(true);
        }else{
            for (int i = 0; i < page.length; i++) {
                wb.getWorksheets().get(i).setVisible(true);
            }
        }
    }
}