package oth.syk.common.http.interceptor.outer;

import java.io.IOException;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import oth.syk.common.http.interceptor.OuterChain;
import oth.syk.common.http.interceptor.OuterInterceptor;

public class ExecutorInterceptor implements OuterInterceptor {
	
	private OkHttpClient okHttpClient;
	
	public ExecutorInterceptor(OkHttpClient okHttpClient) {
		this.okHttpClient = okHttpClient;
	}

	@Override
	public Response intercept(OuterChain oChain) throws IOException {
		Request request = oChain.getRequest();
		return okHttpClient.newCall(request).execute();
	}

//	public void setOkHttpClient(OkHttpClient okHttpClient) {
//		this.okHttpClient = okHttpClient;
//	}

}
