package oth.syk.common.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.gogo.common.http.HttpResult;
import com.gogo.common.http.callback.HttpSendCallback;
import com.gogo.common.ui.HttpException;
import com.gogo.common.ui.MultiFile;

import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.Request.Builder;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils1 {
	private static final String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36";
	
	public static <T> HttpResult<T> httpGet(String url, Map<String, String> params, HttpSendCallback<T> callback) throws UnsupportedEncodingException {
		if(params != null && params.size() > 0) {
			StringBuilder sb = new StringBuilder();
			for(String str : params.keySet()) {
				if(StringUtils.isBlank(params.get(str))) {
					continue;
				}
				String val = URLEncoder.encode(params.get(str), "utf-8");
				sb.append("&").append(str).append("=").append(val);
			}
			url = url + "?" + sb.substring(1);
		}
		Request request = buildRequest(url, null);
		return excute(request, callback);
	}
	
	public static String httpGet(String url, Map<String, String> params) throws Exception {
		return httpGet(url, params, new HttpSendCallback<String>() {
			@Override
			public String onResponse(Response response) throws Exception {
				if (!response.isSuccessful()) {
					throw new HttpException(response.code(), response.message(), response.request().url().url().toString());
				}
				return response.body().string();
			}
		}).getValue();
	}
	
	
	public static String httpGet(String url) throws Exception {
		return httpGet(url, null);
	}
	
	
	@SuppressWarnings("deprecation")
	public static <T, PARAMS> HttpResult<T> jsonPost(String url, PARAMS params, HttpSendCallback<T> callback) {
		MediaType mediaType = MediaType.parse("application/json;charset=UTF-8");
		RequestBody body = null;
		if(params != null) {
			String paramStr = JSON.toJSONString(params);
			body = RequestBody.create(mediaType, paramStr);
		}
		Request request = buildRequest(url, body);
		
		return excute(request, callback);
	}
	
	public static <PARAMS> String jsonPost(String url, PARAMS params) throws Exception {
		return jsonPost(url, params, new HttpSendCallback<String>() {
			@Override
			public String onResponse(Response response) throws Exception {
				if (!response.isSuccessful()) {
					throw new HttpException(response.code(), response.message(), response.request().url().url().toString());
				}
				return response.body().string();
			}
		}).getValue();
	}
	
	public static String jsonPost(String url) throws Exception {
		return jsonPost(url, null);
	}
	

	public static <T> HttpResult<T> httpPost(String url, Map<String, String> params, HttpSendCallback<T> callback) throws IOException {
		FormBody body = null;
		if(params != null) {
			FormBody.Builder builder = new FormBody.Builder();
			if (params != null) {
				for (Map.Entry<String, String> entry : params.entrySet()) {
					builder.add(entry.getKey(), entry.getValue());
				}
			}
			body = builder.build();
		}
		Request request = buildRequest(url, body);
		return excute(request, callback);
	}
	
	public static String httpPost(String url, Map<String, String> params) throws Exception {
		return httpPost(url, params, new HttpSendCallback<String>() {
			@Override
			public String onResponse(Response response) throws Exception {
				if (!response.isSuccessful()) {
					throw new HttpException(response.code(), response.message(), response.request().url().url().toString());
				}
				return response.body().string();
			}
		}).getValue();
	}
	
	public static String httpPost(String url) throws Exception {
		return httpPost(url, null);
	}
	
	@SuppressWarnings("deprecation")
	public static <T> HttpResult<T> httpUpload(String url, List<MultiFile> files, Map<String, String> params, HttpSendCallback<T> callback) {
		MediaType mediaType = MediaType.parse("application/octet-stream");
		MultipartBody.Builder multipartBody = new MultipartBody.Builder();
		multipartBody.setType(MultipartBody.FORM);
		for(MultiFile file : files) {
			RequestBody requestFile = RequestBody.create(mediaType, file.getFile());
			multipartBody.addFormDataPart(file.getName(), file.getFileName(), requestFile);
        }
		for(String key : params.keySet()) {
			multipartBody.addFormDataPart(key, params.get(key));
        }
		RequestBody requestBody = multipartBody.build();
		
		Request request = buildRequest(url, requestBody);
		
		return excute(request, callback);
	}
	
	public static String origGet(String url, Map<String, String> params) throws Exception {
		HttpURLConnection connection = null;
        InputStream is = null;
        try {
        	if(params != null && params.size() > 0) {
				StringBuilder sb = new StringBuilder();
				for(String str : params.keySet()) {
					if(StringUtils.isBlank(params.get(str))) {
						continue;
					}
					String val = URLEncoder.encode(params.get(str), "utf-8");
					sb.append("&").append(str).append("=").append(val);
				}
				url = url + "?" + sb.substring(1);
			}
			URL u = new URL(url);
			connection = (HttpURLConnection) u.openConnection();
			connection.setRequestMethod("GET");
			connection.setConnectTimeout(120000);
			connection.setReadTimeout(120000);
			connection.connect();
			if(connection.getResponseCode() != 200) {
				is = connection.getErrorStream();
				String parseStream = parseStream(is);
				throw new HttpException(connection.getResponseCode(), parseStream, connection.getURL().toString());
			}
	        is = connection.getInputStream();
	        return parseStream(is);
        } finally {
        	if (is != null) {
            	is.close();
            }
            if(connection != null) {
            	connection.disconnect();// 关闭远程连接
            }
        }
	}
	
	/**
	 * 将网络文件转换为byte[]
	 * @param url
	 * @return
	 * @throws UnsupportedEncodingException 
	 * @throws Exception
	 */
	public static byte[] getBytes(String url) throws Exception {
		return HttpUtils1.httpGet(url, null, new HttpSendCallback<byte[]>() {
			@Override
			public byte[] onResponse(Response response) throws Exception{
				if(!response.isSuccessful()){
					throw new RuntimeException("下载文件失败："+url+"响应码："+response.code());
				}
				byte[] bodyBytes = response.body().bytes();
				return bodyBytes;
			}
		}).getValue();
	}
	
	private static String parseStream(InputStream is) throws IOException {
		if(is == null) {
			return null;
		}
		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
	        StringBuffer sb = new StringBuffer();
	        String temp = null;
	        while ((temp = br.readLine()) != null) {
	        	sb.append(temp);
	        	sb.append("\r\n");
	        }
	        return sb.toString();
		} finally {
			if(br != null) {
				br.close();
			}
		}
	}

	private static Request buildRequest(String url, RequestBody body) {
		Builder builder = new Request.Builder().url(url);
		builder.header("User-Agent", userAgent);
		if (body != null) {
			builder.post(body);
		}
		return builder.build();
	}

	public static final HttpClient getHttpClient() {
		return HttpClient.getHttpClient();
//		 return HttpClient.getHttpClient().addOInterceptor(new UserAgentInterceptor());
	}
	
	private static <T> HttpResult<T> excute(Request request, HttpSendCallback<T> callback) {
		HttpClient httpClient = getHttpClient();
		Response response = null;
		HttpResult<T> result = new HttpResult<T>();
		try {
			response = httpClient.execute(request);
			if (!response.isSuccessful()) {
				throw new HttpException(response.code(), response.message(), response.request().url().url().toString());
			}
			result.setValue(callback.onResponse(response));
		} catch (Exception e) {
			result.setException(e);
			result.setHasException(true);
		} finally {
			if (response != null) {
				response.close();
				response = null;
			}
		}
		return result;
	}
}
