package oth.syk.common.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.gogo.common.enums.DBTypeEnum;
import com.gogo.common.ui.DBInfo;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SqlProccess1 {
	
	private DBTypeEnum type;
	private DBInfo dbInfo;
	
	public SqlProccess1(DBTypeEnum type) {
		this.type = type;
	}
	
	public SqlProccess1(DBTypeEnum type, DBInfo dbInfo) {
		this.type = type;
		this.dbInfo = dbInfo;
	}
	
	public List<Map<String, Object>> select(String sql, List<Object> params) throws Exception {
		Connection connection = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			connection = MyDataSource.getConnection(type, dbInfo);
			ps = connection.prepareStatement(sql);
			String paramstr = "";
			if(params != null && params.size() > 0) {
				for(int i=0; i<params.size(); i++) {
					Object object = params.get(i);
					paramstr = paramstr + "," + String.valueOf(object);
					ps.setObject(i+1, object);
				}
				paramstr = paramstr.substring(1);
			}
            log.info("SQL:{}", sql);
            log.info("PARAMS:{}", paramstr);
			rs = ps.executeQuery();
			return build(rs);
			
		} finally {
			if(rs != null) {
				rs.close();
			}
			if(ps != null) {
				ps.close();
			}
			if(connection != null) {
				connection.close();
			}
		}
	}
	
	protected List<Map<String, Object>> build(ResultSet rs) throws Exception {
		List<Map<String, Object>> ts = new ArrayList<Map<String, Object>>();
		int count = 0;
		ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        while (rs.next()) {
        	count++;
        	Map<String, Object> map = new HashMap<>();
        	for (int i = 1; i <= columnCount; i++) {
        		map.put(md.getColumnName(i), rs.getObject(i));
            }
			ts.add(map);
			System.out.println(JSONObject.toJSONString(map));
        }
        log.info("SIZE:{}", count);
        return ts;
	}
}
