package oth.syk.common.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

import org.apache.commons.lang3.StringUtils;

import com.gogo.common.enums.DBTypeEnum;
import com.gogo.common.tools.ConfigUtils;
import com.gogo.common.ui.DBInfo;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyDataSource {
	private static ConcurrentHashMap<String, LinkedBlockingQueue<Connection>> keyPool = new ConcurrentHashMap<String, LinkedBlockingQueue<Connection>>();
	
	private static String dbIp;
	private static String dbPort;
	private static String dbName;
	private static String dbUsername;
	private static String dbPassword;
	
	static {
		dbIp = ConfigUtils.getPropertyValue("db.ip");
		dbPort = ConfigUtils.getPropertyValue("db.port");
		dbName = ConfigUtils.getPropertyValue("db.name");
		dbUsername = ConfigUtils.getPropertyValue("db.username");
		dbPassword = ConfigUtils.getPropertyValue("db.password");
	}
	
	private static String getKey() {
		StringBuilder sb = new StringBuilder();
		return sb.append(dbIp).append("-").append(dbPort).append("-").append(dbName).append("-").append(dbUsername).append("-").append(dbPassword).toString();
	}
	
	private static void init(DBInfo dbInfo) {
		if(dbInfo != null) {
			dbIp = dbInfo.getIp();
			dbPort = dbInfo.getPort()+"";
			dbName = dbInfo.getDbName();
			dbUsername = dbInfo.getUsername();
			dbPassword = dbInfo.getPassword();
		}
	}

	public static Connection getConnection(DBTypeEnum type, DBInfo dbInfo) throws Exception {
		init(dbInfo);
		String key = getKey();
		LinkedBlockingQueue<Connection> pool = keyPool.get(key);
		if(pool == null) {
			pool = new LinkedBlockingQueue<Connection>();
			keyPool.put(key, pool);
		}
		Connection connection = pool.poll();
		if(connection == null) {
			connection = newConnection(type);
		}
		return connection;
	}
	
	private static Connection newConnection(DBTypeEnum type) throws Exception {
		type.check(dbIp, dbPort, dbName, dbUsername, dbPassword);
		Properties prop = new Properties();  
        prop.put("charset", "utf-8");
        if(StringUtils.isNotBlank(dbUsername)) {
        	prop.put("user", dbUsername);
        }
        if(StringUtils.isNotBlank(dbPassword)) {
        	prop.put("password", dbPassword);
        }
        String driverClass = type.getDriverClass();
        String url = type.getUrl(dbIp, dbPort, dbName);
        log.info("===db.url: {}", url);
        log.info("===driverClass: {}", driverClass);
        Class.forName(driverClass);
		Connection connection = DriverManager.getConnection(url,prop);
		LinkedBlockingQueue<Connection> pool = keyPool.get(getKey());
		return new MyConnection(connection, pool);
	}
}
