package com.gogo.mvc.controller;

import java.util.ArrayList;
import java.util.List;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import com.gogo.common.ui.ResultApi;
import com.gogo.mvc.tools.Betters;
import com.gogo.mvc.tools.RunnableDemo;

import lombok.extern.slf4j.Slf4j;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
public class ThisController {
	
	@GetMapping("normal")
	public ResultApi<String> normal() throws Exception{
        int colors = 256;
        int nindex8 = 0;
        List<Integer> couts = new ArrayList<>();
		String threadName = "ab";
		RunnableDemo R1 = new RunnableDemo(threadName, nindex8, couts, colors);
        R1.start();
		return ResultApi.success();
	}
	
	@GetMapping("better")
	public ResultApi<String> better() throws Exception{
		int colors = 256;
		boolean boo = Betters.getBoo(colors);
		int i = Betters.getI();
		Betters.better(boo, i);
		return ResultApi.success();
	}
	
	@GetMapping("best")
	public ResultApi<String> best() throws Exception{
		int colors = 256;
		boolean boo = Betters.getBoo(colors);
		Betters.vanish();
		int i = Betters.getI();
		Betters.better(boo, i);
		return ResultApi.success();
	}
}
