package com.gogo.common.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

import com.gogo.common.tools.DateUtil;
import com.gogo.common.tools.ZillowUtils;

import cn.hutool.core.collection.CollectionUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class Zillow {
	@Data
	public static class Searchresults {
		private Message message;
		private Response response;
		
		public Searchresults(Element element) {
			Element messageE = element.element("message");
			Element responseE = element.element("response");
			if(messageE != null) {
				this.message = new Message(messageE);
			}
			if(responseE != null) {
				this.response = new Response(responseE);
			}
		}
	}
	
	@Data
	public static class Response {
		private List<Result> results;
		
		public Response(Element element) {
			Element resultsE = element.element("results");
			if(resultsE != null) {
				List<Element> elements = resultsE.elements();
				if(CollectionUtil.isNotEmpty(elements)) {
					this.results = new ArrayList<Result>();
					for(Element e : elements) {
						results.add(new Result(e));
					}
				}
				
			}
		}
		
	}
	
	@Data
	public static class Message{
		private String text;
		private Integer code;
		public Message(Element element) {
			Element textE = element.element("text");
			Element codeE = element.element("code");
			if(textE != null) {
				String text = textE.getText();
				this.text=text;
			}
			if(codeE != null) {
				String code = codeE.getText();
				if(StringUtils.isNotBlank(code)) {
					this.code = Integer.valueOf(code);
				}
			}
		}
	}
	
	@Data
	public static class Result{
		private Zestimate zestimate;
		
		public Result(Element element) {
			Element zestimateE = element.element("zestimate");
			if(zestimateE != null) {
				this.zestimate = new Zestimate(zestimateE);
			}
		}
	}
	
	@Data
	public static class Zestimate {
		private Integer amount;
		private Date lastUpdated;
		private ValuationRange valuationRange;
		private Integer percentile;
		
		public Zestimate(Element element) {
			Element amountE = element.element("amount");
			Element lastUpdatedE = element.element("last-updated");
			Element valuationRangeE = element.element("valuationRange");
			Element percentileE = element.element("percentile");
			
			if(amountE != null) {
				String amount = amountE.getText();
				if(StringUtils.isNotBlank(amount)) {
					this.amount = Integer.valueOf(amount);
				}
			}
			if(lastUpdatedE != null) {
				String lastUpdated = lastUpdatedE.getText();
				if(StringUtils.isNotBlank(lastUpdated)) {
					try {
						this.lastUpdated = DateUtil.str2Date(lastUpdated);
					} catch (Exception e) {
						log.error("",e);
					}
				}
			}
			if(valuationRangeE != null) {
				this.valuationRange = new ValuationRange(valuationRangeE);
			}
			if(percentileE != null) {
				String percentile = percentileE.getText();
				if(StringUtils.isNotBlank(percentile)) {
					this.percentile = Integer.valueOf(percentile);
				}
			}
		}
	}
	
	@Data
	public static class ValuationRange {
		private Integer low;
		private Integer high;
		
		public ValuationRange(Element element) {
			Element lowE = element.element("low");
			if(lowE != null) {
				String low = lowE.getText();
				if(StringUtils.isNotBlank(low)) {
					this.low = Integer.valueOf(low);
				}
			}
			Element highE = element.element("high");
			if(highE != null) {
				String high = highE.getText();
				if(StringUtils.isNotBlank(high)) {
					this.high = Integer.valueOf(high);
				}
			}
		}
	}
}
