package com.gogo.common.ui;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@SuppressWarnings({ "serial" })
@ApiModel
public class ResultApi<T> implements Serializable {
	@ApiModelProperty("响应数据")
	private T data;
	@ApiModelProperty("响应错误时，显示错误信息")
	private String[] msg;
	/**
	 * 1打头代表系统信息
	 *	1000：请求成功
	 * 
	 * 2打头代表业务信息
	 * 	2000：未知错误
	 * 	2001：用户名或密码错误
	 */
	@ApiModelProperty("响应代码")
	private Integer code;
	
	private Boolean success;
	
	private static String[] defaultMsg = new String[] {"未知错误"};
	private static int defaultCode = 1000;
	private static int defaultErrorCode = 2000;
	
	private ResultApi() {}

	public static <T> ResultApi<T> success() {
		return success(null);
	}

	public static <T> ResultApi<T> success(T data) {
		ResultApi<T> resultApi = new ResultApi<T>();
		resultApi.setData(data);
		resultApi.setSuccess(true);
		resultApi.setCode(defaultCode);
		return resultApi;
	}
	
	public static <T> ResultApi<T> error(String msg) {
		String[] msgs = new String[]{msg};
		return error(defaultErrorCode, msgs);
	}
	
	public static <T> ResultApi<T> error(String[] msgs) {
		return error(defaultErrorCode, msgs);
	}
	
	public static <T> ResultApi<T> error(int code, String msg) {
		String[] msgs = new String[]{msg};
		return error(code, msgs);
	}
	
	public static <T> ResultApi<T> error(Throwable t) {
		int errorCode = defaultErrorCode;
		String msg = t.getMessage();
		return error(errorCode, msg);
	}
	
	public static <T> ResultApi<T> error(int code, String[] msgs) {
		ResultApi<T> resultApi = new ResultApi<T>();
		resultApi.setCode(code);
		resultApi.setMsg(msgs);
		resultApi.setSuccess(false);
		return resultApi;
	}
	
	public T getData() {
		return data;
	}
	public void setData(T data) {
		this.data = data;
	}
	public String[] getMsg() {
		return msg;
	}
	public void setMsg(String[] msg) {
		this.msg = msg;
	}
	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}
	
	public Boolean isSuccess() {
		return success;
	}

	public void setSuccess(Boolean success) {
		this.success = success;
	}
	
}
