package com.gogo.common.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import lombok.Data;

@Data
public class ResetDayTime {
	private Long startDateTs;
	private Long endDateTs;
	private Date startDate;
	private Date endDate;
	private Calendar startCa;
	private Calendar endCa;
	private Date startTime;
	private Date endTime;
	private String startTimeStr;
	private String endTimeStr;
	
	public void add(int field, int amount) throws ParseException {
		SimpleDateFormat yMd = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat yMdHms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		
		this.startCa.add(field, amount);
		this.startTime = startCa.getTime();
		String startTimeStr = yMdHms.format(startTime);
		this.startTimeStr = startTimeStr;
		String startDateStr = yMd.format(startTime);
		this.startDate = yMd.parse(startDateStr);
		this.startDateTs = this.startDate.getTime();
		
		this.endCa.add(field, amount);
		this.endTime = endCa.getTime();
		String endTimeStr = yMdHms.format(endTime);
		this.endTimeStr = endTimeStr;
		String endDateStr = yMd.format(endTime);
		this.endDate = yMd.parse(endDateStr);
		this.endDateTs = this.endDate.getTime();
	}
}
