package com.gogo.common.ui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 分页参数
 * @Author Administrator
 * @Date 2019/4/8 15:54
 * @Version 1.0
 **/
@Data
@ApiModel
public class MongoPageParam implements Serializable {
    private static final long serialVersionUID = 6166256186832850214L;
    @ApiModelProperty("当前页码")
    private int pageNum = 1;
    

    @ApiModelProperty("每页数据条数")
    private int pageSize = (Integer.MAX_VALUE-1);
    
    private int pageIdx;
    
    @ApiModelProperty("排序字段")
    private String orderBy;
    
    @ApiModelProperty("搜索关键字")
    private String keyword;
    
    public void setPageNum(int pageNum) {
    	if(pageNum < 1) {
    		throw new RuntimeException("pageNum must not be less than 1");
    	}
    	this.pageNum = pageNum;
    	this.pageIdx = pageNum - 1;
    }
}
