package com.gogo.common.ui;

import lombok.Getter;

public class Cron {
	@Getter
	public static class Year{
		private int[] vals;

		private Year() {}
		
		public static Year get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("年不能为空！");
			}
			Year year = new Year();
			year.vals = vals;
			return year;
		}
	}
	
	@Getter
	public static class Month{
		private int[] vals;
		
		private Month() {}
		
		public static Month get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("月不能为空！");
			}
			Month month = new Month();
			month.vals = vals;
			return month;
		}
	}
	
	@Getter
	public static class Day{
		private int[] vals;

		private Day() {}
		
		public static Day get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("日不能为空！");
			}
			Day day = new Day();
			day.vals = vals;
			return day;
		}
	}
	
	@Getter
	public static class Hour{
		private int[] vals;

		private Hour() {}
		
		public static Hour get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("时不能为空！");
			}
			Hour hour = new Hour();
			hour.vals = vals;
			return hour;
		}
	}
	
	@Getter
	public static class Minute{
		private int[] vals;

		private Minute() {}
		
		public static Minute get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("分不能为空！");
			}
			Minute minute = new Minute();
			minute.vals = vals;
			return minute;
		}
	}
	
	@Getter
	public static class Second{
		private int[] vals;

		private Second() {}
		
		public static Second get(int... vals) {
			if(vals == null) {
				throw new RuntimeException("秒不能为空！");
			}
			Second second = new Second();
			second.vals = vals;
			return second;
		}
	}
	
	@Getter
	public static class Week{
		private int[] vals;

		private Week() {}
		
		public static Week get(int... vals) {
			return get(false, vals);
		}
		
		public static Week get(boolean isTransferCronIdx, int... vals) {
			if(vals == null) {
				throw new RuntimeException("周不能为空！");
			}
			int[] newVals = new int[vals.length];
			if(isTransferCronIdx) {
				for(int i=0; i<vals.length; i++) {
					int val = vals[i];
					if(val == 0 || (++val) > 7) {
						val=1;
					}
					newVals[i]=val;
				}
			}else {
				newVals = vals;
			}
			Week week = new Week();
			week.vals = newVals;
			return week;
		}
	}
}
