package com.gogo.common.tools;

import java.util.Map;

import com.gogo.common.ui.WeChat;

import oth.syk.common.tools.WechatUtils1;

public class WechatUtils {
	public static final String prePayParamModel = "<xml>" + 
			"<appid>${appid}</appid>" + 
			"<mch_id>${mch_id}</mch_id>" + 
			"<nonce_str>${nonce_str}</nonce_str>" + 
			"<sign>${sign}</sign>" + 
			"<body>${body}</body>" + 
			"<out_trade_no>${out_trade_no}</out_trade_no>" + 
			"<total_fee>${total_fee}</total_fee>" + 
			"<spbill_create_ip>${spbill_create_ip}</spbill_create_ip>" + 
			"<notify_url>${notify_url}</notify_url>" + 
			"<trade_type>JSAPI</trade_type>" + 
			"<openid>${openid}</openid>" + 
			"</xml>";
	
	public static WeChat.session getUserSession(String appid, String secret, String breakCode) throws Exception {
		return WechatUtils1.getUserSession(appid, secret, breakCode);
	}
	
	public static Map<String, Object> prePay(String xmlParams) throws Exception {
		return WechatUtils1.prePay(xmlParams);
	}
	
	public static String decryptData(String encryptDataB64, String sessionKeyB64, String ivB64) throws Exception {
		return WechatUtils1.decryptData(encryptDataB64, sessionKeyB64, ivB64);
	}
	
	public static String getUserInfo(String accessToken, String ffhOpenId) throws Exception {
		return WechatUtils1.getUserInfo(accessToken, ffhOpenId);
	}
	
	public static WeChat.token getAccessToken(String appid, String secret) throws Exception {
		return WechatUtils1.getAccessToken(appid, secret);
	}
	
	public static String sendModelMessage(String accessToken, WeChat.modelMsg message) throws Exception {
		return WechatUtils1.sendModelMessage(accessToken, message);
	}
}
