package com.gogo.common.tools;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gogo.common.enums.DayTimeEnum;
import com.gogo.common.ui.Over;
import com.gogo.common.ui.ResetDayTime;

import lombok.Data;
import oth.syk.common.tools.Utils1;

public class Utils {
	
	public static boolean isMinimumType(Class<?> clazz) {
		return Utils1.isMinimumType(clazz);
	}
	
	public static byte[] objectToByte(Object obj) throws IOException {  
	    return Utils1.objectToByte(obj);
	}
	
	public static Object byteToObject(byte[] bytes) {
		return Utils1.byteToObject(bytes);
    }
	
	public static <T> T getChange(Class<T> cls, T newObj, T old) throws Exception {
    	return Utils1.getChange(cls, newObj, old);
    }
	
	/**  
     * 生成32位编码  
     * @return string  
     */    
    public static String getUUID(){
        return Utils1.getUUID();
    }
	
	public static String unicode2Chinese(String unicode){
		return Utils1.unicode2Chinese(unicode);
	}
	
    public static String int2ChineseNumber(String i){
    	return Utils1.int2ChineseNumber(i);
    } 
	
	public static int chineseNumber2Int(String chineseNumber){
		return Utils1.chineseNumber2Int(chineseNumber);
	}
	
	public static String encode(String str, String charset) {
		return Utils1.encode(str, charset);
	}
	
	public static boolean containsOne(List<String> all, List<String> sub){
		return Utils1.containsOne(all, sub);
	}
	
	public static String getHostUrl(String host, String uri){
		return Utils1.getHostUrl(host, uri);
	}
	
	public static String base64(String str, String charset) throws UnsupportedEncodingException{
		return Utils1.base64(str, charset);
	}
	
	public static <T, V> Map<T, V> getMap(List<V> list, String keyField) throws Exception{
		return Utils1.getMap(list, keyField);
	}
	
	public static <T, V> Map<T, List<V>> getMapListVal(List<V> list, String keyField) throws Exception{
		return Utils1.getMapListVal(list, keyField);
	}
	
	public static <V, O> V getVal(String key, O o) throws Exception{
		return Utils1.getVal(key, o);
	}
	
	public static <O> void setVal(String key, Object v, O o) throws Exception {
		Utils1.setVal(key, v, o);
	}
	
	public static <O> void setValToned(String key, Object v, O o) throws Exception {
		Utils1.setValToned(key, v, o);
	}
	
	public static <T> List<List<T>> groupList(List<T> list, int groupSize) {
		return Utils1.groupList(list, groupSize);
	}
	
	public static ResetDayTime getDayTime(Date date, DayTimeEnum dayTime, int addDay) throws ParseException {
		return Utils1.getDayTime(date, dayTime, addDay);
	}
	
	public static <T> Over<T> getOvers2(List<T> list1, List<T> list2, boolean obj, String attr, String...subs) throws Exception {
		return Utils1.getOvers2(list1, list2, obj, attr, subs);
	}
	
	public static <O> Map<String, String> obj2Map(O o, boolean isSaveNull) throws Exception{
		return Utils1.obj2Map(o, isSaveNull);
	}
	
	public static boolean isEquals(String a, String b) {
    	return Utils1.isEquals(a, b);
    }
	
	public static boolean isEquals(Number a, Number b) {
		return Utils1.isEquals(a, b);
    }
	
	public static boolean isEquals(Number a, String b) {
		return Utils1.isEquals(a, b);
    }
	
	public static boolean isEquals(String a, Number b) {
		return Utils1.isEquals(a, b);
    }

}
